/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;

public class WordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/en/coherency.txt");

    public WordCoherencyRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.addExamplePair(Example.wrong((String)"He likes archaeology. Really? She likes <marker>archeology</marker>, too."), Example.fixed((String)"He likes archaeology. Really? She likes <marker>archaeology</marker>, too."));
    }

    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    protected String getMessage(String word1, String word2) {
        return "Do not mix variants of the same word ('" + word1 + "' and '" + word2 + "') within a single text.";
    }

    public String getId() {
        return "EN_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Coherent spelling of words with two admitted variants.";
    }
}

