/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.graph;

import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.freeplane.plugin.codeexplorer.graph.GraphExplorer;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.JohnsonSimpleCycles;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

public class GraphCycleFinder<V> {
    private static final CycleSearchStopException CYCLE_SEARCH_STOP_EXCEPTION = new CycleSearchStopException();
    private final Graph<Object, DefaultEdge> graph = new SimpleDirectedGraph(DefaultEdge.class);

    public DefaultEdge addEdge(V source, V target) {
        return this.addEdgeObject(source, target);
    }

    DefaultEdge addEdgeObject(Object source, Object target) {
        this.graph.addVertex(source);
        this.graph.addVertex(target);
        return (DefaultEdge)this.graph.addEdge(source, target);
    }

    public boolean addNode(V v) {
        return this.graph.addVertex(v);
    }

    public void stopSearchHere() {
        this.addEdgeObject((Object)StopEdgeNode.START, (Object)StopEdgeNode.STOP);
        this.addEdgeObject((Object)StopEdgeNode.STOP, (Object)StopEdgeNode.START);
    }

    public void exploreGraph(Iterable<V> startVertices, Function<V, Stream<V>> outgoingEdgesProvider, Function<V, Stream<V>> incomingEdgesProvider) {
        GraphExplorer.exploreGraph(this.graph, startVertices, outgoingEdgesProvider, incomingEdgesProvider);
    }

    public Set<Map.Entry<V, V>> findSimpleCycles() {
        LinkedHashSet result = new LinkedHashSet();
        JohnsonSimpleCycles cycleFinder = new JohnsonSimpleCycles(this.graph);
        try {
            cycleFinder.findSimpleCycles(cycle -> {
                if (cycle.get(0) == StopEdgeNode.START) {
                    throw CYCLE_SEARCH_STOP_EXCEPTION;
                }
                List typedCycle = cycle;
                for (int n = 0; n < typedCycle.size(); ++n) {
                    Object origin = typedCycle.get(n);
                    Object target = typedCycle.get((n + 1) % cycle.size());
                    result.add(new AbstractMap.SimpleEntry(origin, target));
                }
            });
        }
        catch (CycleSearchStopException cycleSearchStopException) {
            // empty catch block
        }
        return result;
    }

    private static enum StopEdgeNode {
        START,
        STOP;

    }

    private static class CycleSearchStopException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private CycleSearchStopException() {
        }
    }
}

