﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/HubInfo.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class ListHubsResult {
 public:
  AWS_SAGEMAKER_API ListHubsResult() = default;
  AWS_SAGEMAKER_API ListHubsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API ListHubsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The summaries of the listed hubs.</p>
   */
  inline const Aws::Vector<HubInfo>& GetHubSummaries() const { return m_hubSummaries; }
  template <typename HubSummariesT = Aws::Vector<HubInfo>>
  void SetHubSummaries(HubSummariesT&& value) {
    m_hubSummariesHasBeenSet = true;
    m_hubSummaries = std::forward<HubSummariesT>(value);
  }
  template <typename HubSummariesT = Aws::Vector<HubInfo>>
  ListHubsResult& WithHubSummaries(HubSummariesT&& value) {
    SetHubSummaries(std::forward<HubSummariesT>(value));
    return *this;
  }
  template <typename HubSummariesT = HubInfo>
  ListHubsResult& AddHubSummaries(HubSummariesT&& value) {
    m_hubSummariesHasBeenSet = true;
    m_hubSummaries.emplace_back(std::forward<HubSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the response is truncated, SageMaker returns this token. To retrieve the
   * next set of hubs, use it in the subsequent request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListHubsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListHubsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<HubInfo> m_hubSummaries;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_hubSummariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
