/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.VaultLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import java.util.ArrayList;

public class EscapeCrystal
extends Item {
    public static final String AC_USE = "USE";
    public static String BELONGINGS = "belongings";
    public static String QUICKSLOTS = "quickslots";
    public static String GOLD = "gold";
    public static String ENERGY = "energy";
    public Bundle storedItems;
    public static String STORED_ITEMS = "stored_items";

    public EscapeCrystal() {
        this.image = ItemSpriteSheet.ESCAPE;
        this.unique = true;
        this.defaultAction = AC_USE;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_USE);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_USE) && Dungeon.depth > 15 && Dungeon.depth < 20 && Dungeon.branch == 1 && Dungeon.level instanceof VaultLevel) {
            Sample.INSTANCE.play("sounds/teleport.mp3");
            for (Buff b : hero.buffs()) {
                if (!(b instanceof Wand.Charger) && !(b instanceof Artifact.ArtifactBuff) && !(b instanceof Ring.RingBuff) && !(b instanceof MeleeWeapon.Charger) && !(b instanceof ClassArmor.Charger)) continue;
                b.detach();
            }
            this.restoreHeroBelongings(hero);
            hero.updateHT(false);
            Level.beforeTransition();
            InterlevelScene.curTransition = new LevelTransition(Dungeon.level, hero.pos, LevelTransition.Type.BRANCH_ENTRANCE, Dungeon.depth, 0, LevelTransition.Type.BRANCH_EXIT);
            InterlevelScene.mode = InterlevelScene.Mode.ASCEND;
            Game.switchScene(InterlevelScene.class);
            this.detachAll(hero.belongings.backpack);
        }
    }

    public void storeHeroBelongings(Hero hero) {
        this.storedItems = new Bundle();
        Bundle belongings = new Bundle();
        hero.belongings.storeInBundle(belongings);
        this.storedItems.put(BELONGINGS, belongings);
        Bundle quickslots = new Bundle();
        Dungeon.quickslot.storePlaceholders(quickslots);
        this.storedItems.put(QUICKSLOTS, quickslots);
        this.storedItems.put(GOLD, Dungeon.gold);
        this.storedItems.put(ENERGY, Dungeon.energy);
        Dungeon.quickslot.reset();
        QuickSlotButton.reset();
        Dungeon.energy = 0;
        Dungeon.gold = 0;
        hero.belongings.clear();
    }

    public void restoreHeroBelongings(Hero hero) {
        hero.belongings.clear();
        Dungeon.quickslot.reset();
        Dungeon.quickslot.restorePlaceholders(this.storedItems.getBundle(QUICKSLOTS));
        QuickSlotButton.reset();
        Dungeon.hero.belongings.restoreFromBundle(this.storedItems.getBundle(BELONGINGS));
        Dungeon.gold = this.storedItems.getInt(GOLD);
        Dungeon.energy = this.storedItems.getInt(ENERGY);
        this.storedItems = null;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STORED_ITEMS, this.storedItems);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.storedItems = bundle.getBundle(STORED_ITEMS);
    }
}

