/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class ClioSupport {
    private static ThreadLocal<Long> enterTime = new ThreadLocal();
    private static Logger defaultLogger = Logger.getLogger("oracle.jdbc.logging.ClioSupport");

    private static String toString(Executable method) {
        return method instanceof Constructor ? "<init>" : method.getName();
    }

    public static void log(Logger logger, Level level, Class<?> cls, Executable method, String msg) {
        ClioSupport.log(logger, level, cls, method, msg, null);
    }

    public static void log(Logger logger, Level level, Class<?> cls, Executable method, String msg, Object[] params) {
        Logger l2 = null != logger ? logger : defaultLogger;
        l2.logp(null != level ? level : Level.FINEST, null != cls ? cls.getName() : "null", null != method ? ClioSupport.toString(method) : "null", null != msg ? msg : "null", null != params ? params : new Object[]{});
    }

    private static String receiverToString(Object receiver) {
        return null == receiver ? "        " : Integer.toHexString(receiver.hashCode()).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entering(Logger lgr, Level lvl, Class<?> cls, Executable method, Object receiver, Object ... args) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(ClioSupport.receiverToString(receiver));
        }
        catch (Exception e2) {
            sb.append("[Caught receiver exception]");
        }
        sb.append(" Enter: ");
        if (0 == args.length) {
            sb.append("void");
        } else {
            boolean comma = false;
            for (Object arg : args) {
                String sarg = "";
                try {
                    sarg = OracleLog.argument(arg);
                    sb.append(comma ? ", " : "").append(sarg);
                }
                catch (Throwable t2) {
                    try {
                        StringWriter sw = new StringWriter();
                        t2.printStackTrace(new PrintWriter(sw));
                        sarg = sw.toString();
                        sb.append(comma ? ", " : "").append(sarg);
                    }
                    catch (Throwable throwable) {
                        sb.append(comma ? ", " : "").append(sarg);
                        comma = true;
                        throw throwable;
                    }
                    comma = true;
                    continue;
                }
                comma = true;
            }
        }
        Level level = lvl;
        String clsName = null == cls ? "" : cls.getName();
        String methodName = null == method ? "" : method.getName();
        Logger logger = null == lgr ? Logger.getAnonymousLogger() : lgr;
        logger.logp(level, clsName, methodName, sb.toString());
        enterTime.set(System.nanoTime());
    }

    public static void returning(Logger lgr, Level lvl, Class<?> cls, Executable method, Object receiver) {
        Level level = lvl;
        String clsName = null == cls ? "" : cls.getName();
        String methodName = null == method ? "" : method.getName();
        Logger logger = null == lgr ? Logger.getAnonymousLogger() : lgr;
        try {
            logger.logp(level, clsName, methodName, ClioSupport.receiverToString(receiver) + " Return: void");
        }
        catch (Exception e2) {
            logger.logp(level, clsName, methodName, "[Caught receiver exception]: Return: void");
        }
    }

    public static void returning(Logger lgr, Level lvl, Class<?> cls, Executable method, Object receiver, Object value) {
        Level level = lvl;
        String clsName = null == cls ? "" : cls.getName();
        String methodName = null == method ? "" : method.getName();
        Logger logger = null == lgr ? Logger.getAnonymousLogger() : lgr;
        try {
            logger.logp(level, clsName, methodName, ClioSupport.receiverToString(receiver) + " Return: " + value);
        }
        catch (Exception e2) {
            logger.logp(level, clsName, methodName, "[Caught receiver exception]: Return: " + value);
        }
    }

    public static void throwing(Logger lgr, Level lvl, Class<?> cls, Executable method, Object receiver, Throwable thrown) {
        Level level = lvl;
        String clsName = null == cls ? "" : cls.getName();
        String methodName = null == method ? "" : method.getName();
        Logger logger = null == lgr ? Logger.getAnonymousLogger() : lgr;
        try {
            logger.logp(level, clsName, methodName, ClioSupport.receiverToString(receiver) + " Throw: " + thrown);
        }
        catch (Exception e2) {
            logger.logp(level, clsName, methodName, "[Caught receiver exception]: Throw: " + thrown);
        }
    }

    public static void exiting(Logger lgr, Level lvl, Class<?> cls, Executable method, Object receiver, Throwable thrown) {
        Level level = lvl;
        String clsName = null == cls ? "" : cls.getName();
        String methodName = null == method ? "" : method.getName();
        Logger logger = null == lgr ? Logger.getAnonymousLogger() : lgr;
        try {
            logger.logp(level, clsName, methodName, ClioSupport.receiverToString(receiver) + " Exit: [" + (double)(System.nanoTime() - enterTime.get()) / 1000000.0 + " ms]");
        }
        catch (Exception e2) {
            logger.logp(level, clsName, methodName, "[Caught receiver exception]: Exit [" + (double)(System.nanoTime() - enterTime.get()) / 1000000.0 + " ms]");
        }
    }

    public static boolean publicEnter() {
        return true;
    }

    public static void publicExit() {
    }
}

