/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsJPModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cjkcodecs.DBCSMap;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodec;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibytecodecModuleBuiltins;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_codecs_jp")
public final class CodecsJPModuleBuiltins
extends PythonBuiltins {
    private static final DBCSMap[] MAPPING_LIST = new DBCSMap[11];
    private static final MultibyteCodec[] CODEC_LIST = new MultibyteCodec[7];

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CodecsJPModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonLanguage language = core.getLanguage();
        PythonModule codec = core.lookupBuiltinModule(BuiltinNames.T__CODECS_JP);
        int i = 0;
        MultibytecodecModuleBuiltins.registerCodec("shift_jis", i++, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("cp932", i++, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("euc_jp", i++, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("shift_jis_2004", i++, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("euc_jis_2004", i++, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("euc_jisx0213", i++, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("shift_jisx0213", i, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, language);
        i = 0;
        MultibytecodecModuleBuiltins.registerCodec("jisx0208", -1, null, i++, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0212", -1, null, i++, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisxcommon", -1, null, i++, DBCSMap.MappingType.ENCONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_1_bmp", -1, null, i++, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_2_bmp", -1, null, i++, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_bmp", -1, null, i++, DBCSMap.MappingType.ENCONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_1_emp", -1, null, i++, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_2_emp", -1, null, i++, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_emp", -1, null, i++, DBCSMap.MappingType.ENCONLY, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("jisx0213_pair", -1, null, i++, DBCSMap.MappingType.ENCDEC, MAPPING_LIST, null, codec, language);
        MultibytecodecModuleBuiltins.registerCodec("cp932ext", -1, null, i, DBCSMap.MappingType.ENCDEC, MAPPING_LIST, null, codec, language);
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    @Builtin(name="getcodec", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetCodecNode
    extends PythonUnaryBuiltinNode {
        GetCodecNode() {
        }

        @Specialization
        static Object getcodec(Object encoding, @Bind Node inliningTarget, @Cached TruffleString.EqualNode isEqual, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached CastToTruffleStringNode asUTF8Node, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            if (!unicodeCheckNode.execute(inliningTarget, encoding)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ENCODING_NAME_MUST_BE_A_STRING);
            }
            MultibyteCodec codec = MultibyteCodecUtil.findCodec(CODEC_LIST, asUTF8Node.execute(inliningTarget, encoding), isEqual);
            if (codec == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.LookupError, ErrorMessages.NO_SUCH_CODEC_IS_SUPPORTED);
            }
            PyCapsule codecobj = PFactory.createCapsuleJavaName(language, codec, MultibytecodecModuleBuiltins.PyMultibyteCodec_CAPSULE_NAME);
            return MultibytecodecModuleBuiltins.CreateCodecNode.createCodec(inliningTarget, codecobj, raiseNode);
        }
    }
}

