\name{NormalizeToConstantImageFilter}
\alias{NormalizeToConstantImageFilter}
\title{NormalizeToConstantImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Scales image pixel intensities to make the sum of all pixels equal a
user-defined constant.
NormalizeToConstantImageFilter}
\details{
The default value of the constant is 1. It can be changed with SetConstant() .
This transform is especially useful for normalizing a convolution
kernel.
This code was contributed in the Insight Journal paper: "FFT based
convolution" by Lehmann G. https://insight-journal.org/browse/publication/717
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
NormalizeImageFilter
StatisticsImageFilter
DivideImageFilter
NormalizeToConstant for the procedural interface
itk::NormalizeToConstantImageFilter for the Doxygen on the original ITK class.
NormalizeToConstantImageFilter}
%C++ includes: sitkNormalizeToConstantImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetConstant() const:}{
Set/get the normalization constant.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ NormalizeToConstantImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetConstant(double Constant):}{
Set/get the normalization constant.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NormalizeToConstantImageFilter():}{
Destructor
}
}
}
