/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.opensearch.common.ssl.SslConfigException;

final class PemUtils {
    PemUtils() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static PrivateKey readPrivateKey(Path keyPath, Supplier<char[]> passwordSupplier) throws IOException, PKCSException {
        PrivateKeyInfo pki = PemUtils.loadPrivateKeyFromFile(keyPath, passwordSupplier);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        return converter.getPrivateKey(pki);
    }

    static List<Certificate> readCertificates(Collection<Path> certPaths) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(certPaths.size());
        for (Path path : certPaths) {
            InputStream input = Files.newInputStream(path, new OpenOption[0]);
            try {
                Collection<? extends Certificate> parsed = certFactory.generateCertificates(input);
                if (parsed.isEmpty()) {
                    throw new SslConfigException("Failed to parse any certificate from [" + String.valueOf(path.toAbsolutePath()) + "]");
                }
                certificates.addAll(parsed);
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return certificates;
    }

    private static PrivateKeyInfo loadPrivateKeyFromFile(Path keyPath, Supplier<char[]> passwordSupplier) throws IOException, PKCSException {
        try (PEMParser pemParser = new PEMParser((Reader)Files.newBufferedReader(keyPath, StandardCharsets.UTF_8));){
            Object object;
            Object object2 = object = PemUtils.readObject(keyPath, pemParser);
            Objects.requireNonNull(object2);
            Object object3 = object2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PKCS8EncryptedPrivateKeyInfo.class, PEMEncryptedKeyPair.class, PEMKeyPair.class, PrivateKeyInfo.class}, (Object)object3, n)) {
                case 0: {
                    PKCS8EncryptedPrivateKeyInfo privateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object3;
                    InputDecryptorProvider inputDecryptorProvider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BCFIPS").build(passwordSupplier.get());
                    PrivateKeyInfo privateKeyInfo2 = privateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
                    return privateKeyInfo2;
                }
                case 1: {
                    PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)object3;
                    PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider("BCFIPS").build(passwordSupplier.get());
                    PEMKeyPair keyPair = encryptedKeyPair.decryptKeyPair(decryptorProvider);
                    PrivateKeyInfo privateKeyInfo = keyPair.getPrivateKeyInfo();
                    return privateKeyInfo;
                }
                case 2: {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)object3;
                    PrivateKeyInfo keyPair = pemKeyPair.getPrivateKeyInfo();
                    return keyPair;
                }
                case 3: {
                    PrivateKeyInfo privateKeyInfo;
                    PrivateKeyInfo privateKeyInfo3 = privateKeyInfo = (PrivateKeyInfo)object3;
                    return privateKeyInfo3;
                }
            }
            throw new SslConfigException(String.format(Locale.ROOT, "error parsing private key [%s], invalid encrypted private key class: [%s]", keyPath.toAbsolutePath(), object.getClass().getName()));
        }
    }

    private static Object readObject(Path keyPath, PEMParser pemParser) throws IOException {
        while (pemParser.ready()) {
            try {
                Object object = pemParser.readObject();
                if (object == null || object instanceof ASN1ObjectIdentifier) continue;
                return object;
            }
            catch (IOException iOException) {
            }
        }
        throw new SslConfigException("Error parsing Private Key [" + String.valueOf(keyPath.toAbsolutePath()) + "]. The file is empty, or does not contain expected key format.");
    }

    static {
        int highestPriority = 1;
        if (Security.getProvider("BCFIPS") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleFipsProvider(), highestPriority++);
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleJsseProvider(), highestPriority);
        }
    }
}

