/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpResponse;
import java.util.Collections;
import java.util.List;

public final class RequestRetryCondition {
    private final HttpResponse response;
    private final Throwable throwable;
    private final int tryCount;
    private final List<Throwable> retriedExceptions;

    RequestRetryCondition(HttpResponse response, Throwable throwable, int tryCount, List<Throwable> retriedThrowables) {
        this.response = response;
        this.throwable = throwable;
        this.tryCount = tryCount;
        this.retriedExceptions = retriedThrowables == null ? Collections.emptyList() : Collections.unmodifiableList(retriedThrowables);
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public List<Throwable> getRetriedThrowables() {
        return this.retriedExceptions;
    }
}

