/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.transport.request;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.jobscheduler.spi.JobDocVersion;

public class JobParameterRequest
extends ActionRequest {
    private final String accessToken;
    private final BytesReference jobSource;
    private final String id;
    private final JobDocVersion jobDocVersion;

    public JobParameterRequest(String accessToken, XContentParser jobParser, String id, JobDocVersion jobDocVersion) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.copyCurrentStructure(jobParser);
        this.jobSource = BytesReference.bytes((XContentBuilder)builder);
        this.accessToken = accessToken;
        this.id = id;
        this.jobDocVersion = jobDocVersion;
    }

    public JobParameterRequest(StreamInput in) throws IOException {
        this.accessToken = in.readString();
        this.jobSource = in.readBytesReference();
        this.id = in.readString();
        this.jobDocVersion = new JobDocVersion(in);
    }

    public JobParameterRequest(byte[] requestParams) throws IOException {
        this(StreamInput.wrap((byte[])requestParams));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.accessToken);
        out.writeBytesReference(this.jobSource);
        out.writeString(this.id);
        this.jobDocVersion.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public BytesReference getJobSource() {
        return this.jobSource;
    }

    public String getId() {
        return this.id;
    }

    public JobDocVersion getJobDocVersion() {
        return this.jobDocVersion;
    }
}

