"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_STEP_INTERVAL = exports.DEFAULT_RESOLUTION = void 0;
exports.calculateStep = calculateStep;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Default resolution for step calculation
const DEFAULT_RESOLUTION = exports.DEFAULT_RESOLUTION = 1440;
// Minimum step interval in seconds
const MIN_STEP_INTERVAL = exports.MIN_STEP_INTERVAL = 15;
function roundInterval(intervalMs) {
  if (intervalMs <= 1) return 1;
  const magnitude = Math.pow(10, Math.floor(Math.log10(intervalMs)));
  const normalized = intervalMs / magnitude;
  let nice;
  if (normalized <= 1) nice = 1;else if (normalized <= 2) nice = 2;else if (normalized <= 5) nice = 5;else nice = 10;
  return Math.round(nice * magnitude);
}
function calculateStep(durationMs, resolution = DEFAULT_RESOLUTION, minIntervalSec = MIN_STEP_INTERVAL) {
  const rawIntervalMs = durationMs / resolution;
  const roundedIntervalMs = roundInterval(rawIntervalMs);
  const stepSec = roundedIntervalMs / 1000;
  return Math.max(stepSec, minIntervalSec);
}