/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.replication.action.index.ReplicateIndexAction;
import org.opensearch.replication.action.index.ReplicateIndexRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/replication/rest/ReplicateIndexHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-cross-cluster-replication"})
public final class ReplicateIndexHandler
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_replication/{index}/_start"));
    }

    @NotNull
    public String getName() {
        return "plugins_index_start_replicate_action";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Closeable closeable = (Closeable)request.contentOrSourceParamParser();
        Throwable throwable = null;
        try {
            XContentParser parser = (XContentParser)closeable;
            boolean bl = false;
            String followerIndex = request.param("index");
            Intrinsics.checkNotNull((Object)parser);
            Intrinsics.checkNotNull((Object)followerIndex);
            ReplicateIndexRequest followIndexRequest = ReplicateIndexRequest.Companion.fromXContent(parser, followerIndex);
            followIndexRequest.setWaitForRestore(request.paramAsBoolean("wait_for_restore", false));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = arg_0 -> ReplicateIndexHandler.prepareRequest$lambda$1$lambda$0(client, followIndexRequest, arg_0);
            return restChannelConsumer;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void prepareRequest$lambda$1$lambda$0(NodeClient $client, ReplicateIndexRequest $followIndexRequest, RestChannel channel) {
        $client.admin().cluster().execute((ActionType)ReplicateIndexAction.Companion.getINSTANCE(), (ActionRequest)$followIndexRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

