/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.common.unit.Fuzziness;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.protobufs.MatchQuery;
import org.opensearch.protobufs.MinimumShouldMatch;
import org.opensearch.protobufs.Operator;
import org.opensearch.protobufs.ZeroTermsQuery;
import org.opensearch.transport.grpc.proto.request.search.OperatorProtoUtils;
import org.opensearch.transport.grpc.proto.response.common.FieldValueProtoUtils;

class MatchQueryBuilderProtoUtils {
    private MatchQueryBuilderProtoUtils() {
    }

    static MatchQueryBuilder fromProto(MatchQuery matchQueryProto) {
        if (matchQueryProto == null) {
            throw new IllegalArgumentException("MatchQuery cannot be null");
        }
        String fieldName = matchQueryProto.getField();
        Object value = FieldValueProtoUtils.fromProto(matchQueryProto.getQuery(), false);
        float boost = 1.0f;
        String minimumShouldMatch = null;
        String analyzer = null;
        org.opensearch.index.query.Operator operator = MatchQueryBuilder.DEFAULT_OPERATOR;
        Fuzziness fuzziness = null;
        int prefixLength = 0;
        int maxExpansions = 50;
        boolean fuzzyTranspositions = true;
        String fuzzyRewrite = null;
        boolean lenient = false;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = org.opensearch.index.search.MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
        boolean autoGenerateSynonymsPhraseQuery = true;
        String queryName = null;
        if (matchQueryProto.hasAnalyzer()) {
            analyzer = matchQueryProto.getAnalyzer();
        }
        if (matchQueryProto.hasBoost()) {
            boost = matchQueryProto.getBoost();
        }
        if (matchQueryProto.hasFuzziness()) {
            org.opensearch.protobufs.Fuzziness fuzzinessProto = matchQueryProto.getFuzziness();
            if (fuzzinessProto.hasString()) {
                fuzziness = Fuzziness.build((Object)fuzzinessProto.getString());
            } else if (fuzzinessProto.hasInt32()) {
                fuzziness = Fuzziness.fromEdits((int)fuzzinessProto.getInt32());
            }
        }
        if (matchQueryProto.hasPrefixLength()) {
            prefixLength = matchQueryProto.getPrefixLength();
        }
        if (matchQueryProto.hasMaxExpansions()) {
            maxExpansions = matchQueryProto.getMaxExpansions();
        }
        if (matchQueryProto.hasOperator() && matchQueryProto.getOperator() != Operator.OPERATOR_UNSPECIFIED) {
            operator = OperatorProtoUtils.fromEnum(matchQueryProto.getOperator());
        }
        if (matchQueryProto.hasMinimumShouldMatch()) {
            MinimumShouldMatch minimumShouldMatchProto = matchQueryProto.getMinimumShouldMatch();
            if (minimumShouldMatchProto.hasString()) {
                minimumShouldMatch = minimumShouldMatchProto.getString();
            } else if (minimumShouldMatchProto.hasInt32()) {
                minimumShouldMatch = String.valueOf(minimumShouldMatchProto.getInt32());
            }
        }
        if (matchQueryProto.hasFuzzyRewrite()) {
            fuzzyRewrite = matchQueryProto.getFuzzyRewrite();
        }
        if (matchQueryProto.hasFuzzyTranspositions()) {
            fuzzyTranspositions = matchQueryProto.getFuzzyTranspositions();
        }
        if (matchQueryProto.hasLenient()) {
            lenient = matchQueryProto.getLenient();
        }
        if (matchQueryProto.hasZeroTermsQuery() && matchQueryProto.getZeroTermsQuery() != ZeroTermsQuery.ZERO_TERMS_QUERY_UNSPECIFIED) {
            if (matchQueryProto.getZeroTermsQuery() == ZeroTermsQuery.ZERO_TERMS_QUERY_ALL) {
                zeroTermsQuery = MatchQuery.ZeroTermsQuery.ALL;
            } else if (matchQueryProto.getZeroTermsQuery() == ZeroTermsQuery.ZERO_TERMS_QUERY_NONE) {
                zeroTermsQuery = MatchQuery.ZeroTermsQuery.NONE;
            }
        }
        if (matchQueryProto.hasXName()) {
            queryName = matchQueryProto.getXName();
        }
        if (matchQueryProto.hasAutoGenerateSynonymsPhraseQuery()) {
            autoGenerateSynonymsPhraseQuery = matchQueryProto.getAutoGenerateSynonymsPhraseQuery();
        }
        MatchQueryBuilder matchQuery = new MatchQueryBuilder(fieldName, value);
        matchQuery.operator(operator);
        matchQuery.analyzer(analyzer);
        matchQuery.minimumShouldMatch(minimumShouldMatch);
        matchQuery.fuzziness(fuzziness);
        matchQuery.fuzzyRewrite(fuzzyRewrite);
        matchQuery.prefixLength(prefixLength);
        matchQuery.fuzzyTranspositions(fuzzyTranspositions);
        matchQuery.maxExpansions(maxExpansions);
        matchQuery.lenient(lenient);
        matchQuery.zeroTermsQuery(zeroTermsQuery);
        matchQuery.autoGenerateSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery);
        matchQuery.queryName(queryName);
        matchQuery.boost(boost);
        return matchQuery;
    }
}

