/*
 * Decompiled with CFR 0.152.
 */
package j2html.rendering;

import j2html.Config;
import j2html.rendering.HtmlBuilder;
import j2html.rendering.TagBuilder;
import j2html.utils.TextEscaper;
import java.io.IOException;

public class FlatHtml<T extends Appendable>
implements HtmlBuilder<T> {
    private final T out;
    private final TextEscaper textEscaper;
    private final TagBuilder enclosingElementAttributes;
    private final TagBuilder emptyElementAttributes;

    public static final <T extends Appendable> FlatHtml<T> into(T out) {
        return new FlatHtml<T>(out, Config.defaults());
    }

    public static final <T extends Appendable> FlatHtml<T> into(T out, Config config) {
        return new FlatHtml<T>(out, config);
    }

    public static final FlatHtml<StringBuilder> inMemory() {
        return FlatHtml.into(new StringBuilder());
    }

    public static final FlatHtml<StringBuilder> inMemory(Config config) {
        return FlatHtml.into(new StringBuilder(), config);
    }

    private FlatHtml(T out, Config config) {
        this.out = out;
        this.textEscaper = config.textEscaper();
        this.enclosingElementAttributes = new FlatTagBuilder(false);
        this.emptyElementAttributes = new FlatTagBuilder(config.closeEmptyTags());
    }

    @Override
    public T output() {
        return this.out;
    }

    @Override
    @Deprecated
    public HtmlBuilder<T> append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    @Deprecated
    public HtmlBuilder<T> append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    @Deprecated
    public HtmlBuilder<T> append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    @Override
    public TagBuilder appendStartTag(String name) throws IOException {
        this.out.append("<").append(name);
        return this.enclosingElementAttributes;
    }

    @Override
    public HtmlBuilder<T> appendEndTag(String name) throws IOException {
        this.out.append("</").append(name).append(">");
        return this;
    }

    @Override
    public TagBuilder appendEmptyTag(String name) throws IOException {
        this.out.append("<").append(name);
        return this.emptyElementAttributes;
    }

    @Override
    public HtmlBuilder<T> appendEscapedText(String txt) throws IOException {
        this.out.append(this.textEscaper.escape(txt));
        return this;
    }

    @Override
    public HtmlBuilder<T> appendUnescapedText(String txt) throws IOException {
        this.out.append(txt);
        return this;
    }

    private class FlatTagBuilder
    implements TagBuilder {
        private final boolean closeTag;

        private FlatTagBuilder(boolean closeTag) {
            this.closeTag = closeTag;
        }

        @Override
        public TagBuilder appendAttribute(String name, String value) throws IOException {
            FlatHtml.this.out.append(" ").append(name).append("=\"").append(FlatHtml.this.textEscaper.escape(value)).append("\"");
            return this;
        }

        @Override
        public TagBuilder appendBooleanAttribute(String name) throws IOException {
            FlatHtml.this.out.append(" ").append(name);
            return this;
        }

        public HtmlBuilder<T> completeTag() throws IOException {
            if (this.closeTag) {
                FlatHtml.this.out.append("/");
            }
            FlatHtml.this.out.append(">");
            return FlatHtml.this;
        }

        @Override
        @Deprecated
        public TagBuilder append(CharSequence csq) throws IOException {
            FlatHtml.this.out.append(csq);
            return this;
        }

        @Override
        @Deprecated
        public TagBuilder append(CharSequence csq, int start, int end) throws IOException {
            FlatHtml.this.out.append(csq, start, end);
            return this;
        }

        @Override
        @Deprecated
        public TagBuilder append(char c) throws IOException {
            FlatHtml.this.out.append(c);
            return this;
        }
    }
}

