/*
 * SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ga100_dev_top_addendum_h__
#define __ga100_dev_top_addendum_h__

// Backports from GB100
#define NV_PTOP_ZB_DEVICE_INFO_CFG     0x000004fc
#define NV_PTOP_ZB_DEVICE_INFO(i)      (0x00000800+(i)*4)
#define NV_PTOP_ZB_DEVICE_INFO__SIZE_1 NV_PTOP_DEVICE_INFO2__SIZE_1

#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_PTOP 52

#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_GRAPHICS NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_GRAPHICS
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_NVDEC NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_NVDEC
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_NVENC NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_NVENC
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_NVJPG NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_NVJPG
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_OFA NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_OFA
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_SEC NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_SEC
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_LCE NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_LCE
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_GSP NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_GSP
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_IOCTRL NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_IOCTRL
#define NV_PTOP_ZB_DEVICE_INFO_DEV_TYPE_ENUM_FLA NV_PTOP_DEVICE_INFO2_DEV_TYPE_ENUM_FLA

#endif // __ga100_dev_top_addendum_h__
