# Summary

# Introduction

- [About this documentation](./README.md)

# Setup

- [Introduction](./setup/README.md)
- [Installation](./setup/installation.md)
- [General configuration](./setup/general.md)
- [Database setup](./setup/database.md)
- [Homeserver configuration](./setup/homeserver.md)
- [Configuring a reverse proxy](./setup/reverse-proxy.md)
- [Configure an upstream SSO provider](./setup/sso.md)
- [Running the service](./setup/running.md)
- [Migrating an existing homeserver](./setup/migration.md)

# Topics

- [Policy engine](./topics/policy.md)
- [Authorization and sessions](./topics/authorization.md)
- [Use the Admin API](./topics/admin-api.md)
- [Get an access token](./topics/access-token.md)

# Reference

- [Configuration file reference](./reference/configuration.md)
- [Admin API](./api/index.html)
- [OAuth 2.0 scopes](./reference/scopes.md)
- [Command line tool](./reference/cli/README.md)
    - [`config`](./reference/cli/config.md)
    - [`database`](./reference/cli/database.md)
    - [`manage`](./reference/cli/manage.md)
    - [`server`](./reference/cli/server.md)
    - [`syn2mas`](./reference/cli/syn2mas.md)
    - [`worker`](./reference/cli/worker.md)
    - [`templates`](./reference/cli/templates.md)
    - [`doctor`](./reference/cli/doctor.md)

# Development

- [Contributing](./development/contributing.md)
- [Releasing](./development/releasing.md)
- [Architecture](./development/architecture.md)
- [Database](./development/database.md)
- [Cleanup jobs](./development/cleanup-jobs.md)
- [Internal GraphQL API](./development/graphql.md)

---

[Application Services login](./as-login.md)
