/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class BasicServerJacksonMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private final LazyValue<ObjectWriter> defaultWriter;
    private final Map<JavaType, ObjectWriter> genericWriters = new ConcurrentHashMap<JavaType, ObjectWriter>();

    public BasicServerJacksonMessageBodyWriter() {
        this.defaultWriter = null;
    }

    @Inject
    public BasicServerJacksonMessageBodyWriter(final Instance<ObjectMapper> mapper) {
        this.defaultWriter = new LazyValue((Supplier)new Supplier<ObjectWriter>(){

            @Override
            public ObjectWriter get() {
                return JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)((ObjectMapper)mapper.get()));
            }
        });
    }

    private ObjectWriter getWriter(Type genericType, Object value) {
        JavaType rootType;
        if (value != null && genericType != null && (rootType = JacksonMapperUtil.getGenericRootType(genericType, (ObjectWriter)this.defaultWriter.get())) != null && rootType.isTypeOrSuperTypeOf(value.getClass())) {
            ObjectWriter writer = this.genericWriters.get(rootType);
            if (writer == null) {
                writer = this.genericWriters.computeIfAbsent(rootType, new Function<JavaType, ObjectWriter>(){

                    @Override
                    public ObjectWriter apply(JavaType type) {
                        return ((ObjectWriter)BasicServerJacksonMessageBodyWriter.this.defaultWriter.get()).forType(type);
                    }
                });
            }
            return writer;
        }
        return (ObjectWriter)this.defaultWriter.get();
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes(StandardCharsets.UTF_8));
        } else {
            this.getWriter(genericType, o).writeValue(stream, o);
        }
        stream.close();
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.getWriter(genericType, o));
    }
}

