/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.GizmoMethodVisitor;
import io.quarkus.gizmo.LineNumberWriter;
import java.io.IOException;
import java.io.Writer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class GizmoClassVisitor
extends ClassVisitor {
    private String name;
    private LineNumberWriter writer;
    private GizmoMethodVisitor currentMethod;
    private int indent = 0;

    public GizmoClassVisitor(int api, ClassVisitor classVisitor, Writer zigWriter) {
        super(api, classVisitor);
        this.writer = new LineNumberWriter(zigWriter);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int mod;
        super.visit(version, access, name, signature, superName, interfaces);
        this.name = name;
        this.append("// Class: ").append(name).newLine();
        this.append("//     Access = ");
        block12: for (int mods = access; mods != 0; mods ^= mod) {
            mod = Integer.lowestOneBit(mods);
            switch (mod) {
                case 1: {
                    this.append(" public");
                    continue block12;
                }
                case 2: {
                    this.append(" private");
                    continue block12;
                }
                case 4: {
                    this.append(" protected");
                    continue block12;
                }
                case 8: {
                    this.append(" static");
                    continue block12;
                }
                case 16: {
                    this.append(" final");
                    continue block12;
                }
                case 512: {
                    this.append(" interface");
                    continue block12;
                }
                case 1024: {
                    this.append(" abstract");
                    continue block12;
                }
                case 4096: {
                    this.append(" synthetic");
                    continue block12;
                }
                case 8192: {
                    this.append(" annotation");
                    continue block12;
                }
                case 16384: {
                    this.append(" enum");
                }
            }
        }
        this.newLine();
        if (superName != null) {
            this.append("//     Extends: ").append(superName).newLine();
        }
        if (interfaces != null && interfaces.length > 0) {
            this.append("//     Implements:").newLine();
            for (String iName : interfaces) {
                this.append("//         ").append(iName).newLine();
            }
        }
        this.newLine();
        this.append("// DO NOT MODIFY.  This is not actually a source file; it is a textual representation of generated code.");
        this.newLine();
        this.append("// Use only for debugging purposes.");
        this.newLine().newLine();
    }

    public void visitSource(String source, String debug) {
        int idx = this.name.lastIndexOf(47);
        String fileName = idx == -1 ? this.name + ".zig" : this.name.substring(idx + 1) + ".zig";
        super.visitSource(fileName, null);
    }

    public GizmoMethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        int mod;
        GizmoMethodVisitor zigMethodVisitor;
        if (this.currentMethod != null) {
            throw new IllegalStateException("Multiple active method visitors");
        }
        MethodVisitor delegate = super.visitMethod(access, name, descriptor, signature, exceptions);
        this.currentMethod = zigMethodVisitor = new GizmoMethodVisitor(this.api, delegate, this);
        Type returnType = Type.getReturnType((String)descriptor);
        this.append("// Access:");
        block14: for (int mods = access; mods != 0; mods ^= mod) {
            mod = Integer.lowestOneBit(mods);
            switch (mod) {
                case 1: {
                    this.append(" public");
                    continue block14;
                }
                case 2: {
                    this.append(" private");
                    continue block14;
                }
                case 4: {
                    this.append(" protected");
                    continue block14;
                }
                case 8: {
                    this.append(" static");
                    continue block14;
                }
                case 16: {
                    this.append(" final");
                    continue block14;
                }
                case 32: {
                    this.append(" synchronized");
                    continue block14;
                }
                case 64: {
                    this.append(" bridge");
                    continue block14;
                }
                case 128: {
                    this.append(" varargs");
                    continue block14;
                }
                case 256: {
                    this.append(" native");
                    continue block14;
                }
                case 1024: {
                    this.append(" abstract");
                    continue block14;
                }
                case 2048: {
                    this.append(" strictfp");
                    continue block14;
                }
                case 4096: {
                    this.append(" synthetic");
                }
            }
        }
        this.newLine();
        this.append("Method ").append(name).append(" : ").append(returnType);
        if (exceptions != null && exceptions.length > 0) {
            this.addIndent().newLine().append("throws ");
            this.append(exceptions[0]);
            for (int i = 1; i < exceptions.length; ++i) {
                this.append(", ").append(exceptions[i]);
            }
            this.removeIndent();
        }
        this.newLine().append("(").addIndent().newLine();
        Type[] argumentTypes = Type.getArgumentTypes((String)descriptor);
        if (argumentTypes.length > 0) {
            int base = (access & 8) != 0 ? 0 : 1;
            this.append("arg ").append(base).append(" = ").append(argumentTypes[0]);
            for (int i = 1; i < argumentTypes.length; ++i) {
                this.append(',').newLine();
                this.append("arg ").append(base + i).append(" = ").append(argumentTypes[i]);
            }
        } else {
            this.append("// (no arguments)");
        }
        this.removeIndent().newLine().append(") {").addIndent().newLine();
        return zigMethodVisitor;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        int mod;
        this.append("// Access:");
        block11: for (int mods = access; mods != 0; mods ^= mod) {
            mod = Integer.lowestOneBit(mods);
            switch (mod) {
                case 1: {
                    this.append(" public");
                    continue block11;
                }
                case 2: {
                    this.append(" private");
                    continue block11;
                }
                case 4: {
                    this.append(" protected");
                    continue block11;
                }
                case 8: {
                    this.append(" static");
                    continue block11;
                }
                case 16: {
                    this.append(" final");
                    continue block11;
                }
                case 64: {
                    this.append(" volatile");
                    continue block11;
                }
                case 128: {
                    this.append(" transient");
                    continue block11;
                }
                case 4096: {
                    this.append(" synthetic");
                    continue block11;
                }
                case 16384: {
                    this.append(" enum");
                }
            }
        }
        this.newLine();
        this.append("Field ").append(name).append(" : ").append(Type.getType((String)descriptor)).newLine().newLine();
        return super.visitField(access, name, descriptor, signature, value);
    }

    public void visitEnd() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        super.visitEnd();
    }

    public LineNumberWriter getWriter() {
        return this.writer;
    }

    int getLineNumber() {
        return this.writer.getLineNumber();
    }

    GizmoClassVisitor append(int arg) {
        return this.append(Integer.toString(arg));
    }

    GizmoClassVisitor append(long arg) {
        return this.append(Long.toString(arg));
    }

    GizmoClassVisitor append(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    GizmoClassVisitor append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    GizmoClassVisitor append(String str) {
        try {
            this.writer.write(str);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    GizmoClassVisitor newLine() {
        try {
            this.writer.write(System.lineSeparator());
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write("    ");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    GizmoClassVisitor addIndent() {
        ++this.indent;
        return this;
    }

    GizmoClassVisitor removeIndent() {
        --this.indent;
        return this;
    }

    public void methodVisitEnd() {
        this.currentMethod = null;
        this.removeIndent().newLine().append('}').newLine().newLine();
    }

    GizmoMethodVisitor getCurrentMethod() {
        return this.currentMethod;
    }
}

