/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

public final class ResourceUtils {
    private static final int ST_I_INIT = 0;
    private static final int ST_I_IGNORE = 1;
    private static final int ST_I_D1 = 3;
    private static final int ST_I_D2 = 4;
    private static final int ST_T_INIT = 5;
    private static final int ST_T_SLASH = 6;
    private static final int ST_T_D1 = 7;
    private static final int ST_T_D2 = 8;
    private static final int ST_T_CONTENT = 9;
    private static final int ST_M_INIT = 10;
    private static final int ST_M_D1 = 11;
    private static final int ST_M_D2 = 12;
    private static final int ST_M_IGNORE = 13;
    private static final int ST_C_INIT = 0;
    private static final int ST_C_CONTENT = 1;
    private static final int ST_C_D1 = 2;
    private static final int ST_C_D2 = 3;
    private static final int EOF = -1;

    private ResourceUtils() {
    }

    public static String canonicalizeRelativePath(String path) {
        int length = path.length();
        if (length == 0) {
            return path;
        }
        int idx = length;
        int state = 0;
        int t_end = -1;
        int t_start = -1;
        int skip = 0;
        while (true) {
            int c = idx == 0 ? -1 : (int)path.charAt(idx - 1);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case 46: {
                            state = 3;
                            break block0;
                        }
                        case 47: {
                            break block0;
                        }
                        case -1: {
                            return "";
                        }
                    }
                    if (skip > 0) {
                        --skip;
                        state = 1;
                        break;
                    }
                    t_end = idx;
                    state = 5;
                    break;
                }
                case 1: {
                    switch (c) {
                        case 47: {
                            state = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case 47: {
                            state = 0;
                            break block0;
                        }
                        case 46: {
                            state = 4;
                            break block0;
                        }
                        case -1: {
                            return "";
                        }
                    }
                    if (skip > 0) {
                        --skip;
                        state = 1;
                        break;
                    }
                    t_end = idx + 1;
                    state = 5;
                    break;
                }
                case 4: {
                    switch (c) {
                        case -1: {
                            return "";
                        }
                        case 47: {
                            ++skip;
                            state = 0;
                            break block0;
                        }
                    }
                    if (skip > 0) {
                        --skip;
                        state = 1;
                        break;
                    }
                    t_end = idx + 2;
                    state = 5;
                    break;
                }
                case 5: {
                    switch (c) {
                        case -1: {
                            return path.substring(0, t_end);
                        }
                        case 47: {
                            state = 6;
                            break block0;
                        }
                        case 46: {
                            state = 7;
                            break block0;
                        }
                    }
                    state = 9;
                    break;
                }
                case 6: {
                    switch (c) {
                        case -1: {
                            return path.substring(1, t_end);
                        }
                        case 46: {
                            state = 7;
                            break block0;
                        }
                        case 47: {
                            t_start = idx + 1;
                            state = 10;
                            break block0;
                        }
                    }
                    state = 5;
                    break;
                }
                case 7: {
                    switch (c) {
                        case -1: {
                            return path.substring(2, t_end);
                        }
                        case 46: {
                            state = 8;
                            break block0;
                        }
                        case 47: {
                            t_start = idx + 2;
                            state = 10;
                            break block0;
                        }
                    }
                    state = 9;
                    break;
                }
                case 8: {
                    switch (c) {
                        case -1: {
                            return path.substring(3, t_end);
                        }
                        case 47: {
                            ++skip;
                            t_start = idx + 3;
                            state = 10;
                            break block0;
                        }
                    }
                    state = 9;
                    break;
                }
                case 9: {
                    switch (c) {
                        case -1: {
                            return path.substring(0, t_end);
                        }
                        case 47: {
                            state = 6;
                            break block0;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (c) {
                        case -1: {
                            return path.substring(t_start, t_end);
                        }
                        case 46: {
                            state = 11;
                            break block0;
                        }
                        case 47: {
                            break block0;
                        }
                    }
                    if (skip > 0) {
                        --skip;
                        state = 13;
                        break;
                    }
                    return ResourceUtils.canonicalizeRelativePathWithCopy(path, t_start, t_end, idx);
                }
                case 11: {
                    switch (c) {
                        case -1: {
                            return path.substring(t_start, t_end);
                        }
                        case 46: {
                            state = 12;
                            break block0;
                        }
                        case 47: {
                            state = 10;
                            break block0;
                        }
                    }
                    if (skip > 0) {
                        --skip;
                        state = 13;
                        break;
                    }
                    return ResourceUtils.canonicalizeRelativePathWithCopy(path, t_start, t_end, idx + 1);
                }
                case 12: {
                    switch (c) {
                        case -1: {
                            return path.substring(t_start, t_end);
                        }
                        case 47: {
                            ++skip;
                            state = 10;
                            break block0;
                        }
                    }
                    if (skip > 0) {
                        --skip;
                        state = 13;
                        break;
                    }
                    return ResourceUtils.canonicalizeRelativePathWithCopy(path, t_start, t_end, idx + 2);
                }
                case 13: {
                    switch (c) {
                        case -1: {
                            return path.substring(t_start, t_end);
                        }
                        case 47: {
                            state = 10;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (idx <= 0) continue;
            --idx;
        }
    }

    private static String canonicalizeRelativePathWithCopy(String path, int t_start, int t_end, int init_idx) {
        char[] buf = new char[init_idx + 1 + t_end - t_start];
        int idx = init_idx;
        int c_idx = buf.length - (t_end - t_start);
        path.getChars(t_start, t_end, buf, c_idx);
        int s_end = -1;
        int skip = 0;
        int state = 0;
        while (true) {
            int c = idx == 0 ? -1 : (int)path.charAt(idx - 1);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case -1: {
                            return new String(buf, idx, buf.length - c_idx);
                        }
                        case 46: {
                            state = 2;
                            break block0;
                        }
                        case 47: {
                            break block0;
                        }
                    }
                    s_end = idx;
                    state = 1;
                    break;
                }
                case 2: {
                    switch (c) {
                        case -1: {
                            return new String(buf, c_idx, buf.length - c_idx);
                        }
                        case 46: {
                            state = 3;
                            break block0;
                        }
                        case 47: {
                            state = 0;
                            break block0;
                        }
                    }
                    s_end = idx + 1;
                    state = 1;
                    break;
                }
                case 3: {
                    switch (c) {
                        case -1: {
                            return new String(buf, c_idx, buf.length - c_idx);
                        }
                        case 47: {
                            ++skip;
                            state = 0;
                            break block0;
                        }
                    }
                    s_end = idx + 2;
                    state = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case -1: {
                            if (skip == 0) {
                                buf[--c_idx] = 47;
                                path.getChars(0, s_end, buf, c_idx - s_end);
                            }
                            return new String(buf, c_idx - s_end, buf.length - (c_idx - s_end));
                        }
                        case 47: {
                            if (skip == 0) {
                                buf[--c_idx] = 47;
                                path.getChars(idx, s_end, buf, c_idx - (s_end - idx));
                                c_idx -= s_end - idx;
                            } else {
                                --skip;
                            }
                            state = 0;
                            break block0;
                        }
                    }
                }
            }
            if (idx <= 0) continue;
            --idx;
        }
    }
}

