/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.document;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.document.RdfDocument;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.rdf.Rdf;
import java.io.InputStream;
import java.io.Reader;
import java.util.stream.Collectors;

@Deprecated(since="1.0.4")
public final class DocumentParser {
    private DocumentParser() {
    }

    public static Document parse(MediaType contentType, InputStream inputStream) throws JsonLdError {
        if (inputStream == null) {
            throw new IllegalArgumentException("The provided content InputStream is null.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("The provided content type is null.");
        }
        if (JsonDocument.accepts(contentType)) {
            return JsonDocument.of(contentType, inputStream);
        }
        if (RdfDocument.accepts(contentType)) {
            return RdfDocument.of(contentType, inputStream);
        }
        throw DocumentParser.unsupportedMediaType(contentType);
    }

    public static Document parse(MediaType contentType, Reader reader) throws JsonLdError {
        if (reader == null) {
            throw new IllegalArgumentException("The provided content reader is null.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("The provided content type is null.");
        }
        if (JsonDocument.accepts(contentType)) {
            return JsonDocument.of(contentType, reader);
        }
        if (RdfDocument.accepts(contentType)) {
            return RdfDocument.of(contentType, reader);
        }
        throw DocumentParser.unsupportedMediaType(contentType);
    }

    private static final JsonLdError unsupportedMediaType(MediaType contentType) throws JsonLdError {
        return new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported media type '" + contentType + "'. Supported content types are [" + MediaType.JSON_LD + ", " + MediaType.JSON + ", +json, " + Rdf.canRead().stream().map(MediaType::toString).collect(Collectors.joining(", ")) + "]");
    }
}

