/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ModelsContext;

public class AnnotationUsageHelper {
    public static <A extends Annotation> A findUsage(AnnotationDescriptor<A> type, Map<Class<? extends Annotation>, ? extends Annotation> usageMap) {
        return (A)usageMap.get(type.getAnnotationType());
    }

    public static <A extends Annotation> A getUsage(Class<A> type, Map<Class<? extends Annotation>, ? extends Annotation> usageMap, ModelsContext modelContext) {
        return AnnotationUsageHelper.getUsage(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), usageMap, modelContext);
    }

    public static <A extends Annotation, C extends Annotation> A[] extractRepeatedValues(C container, AnnotationDescriptor<C> containerDescriptor, ModelsContext modelContext) {
        return AnnotationUsageHelper.extractRepeatedValues(container, containerDescriptor.getAttribute("value"), (ModelsContext)modelContext);
    }

    public static <A extends Annotation, C extends Annotation> A[] extractRepeatedValues(C container, AttributeDescriptor<A[]> valuesAttribute, ModelsContext modelContext) {
        return (Annotation[])valuesAttribute.getTypeDescriptor().createJdkValueExtractor(modelContext).extractValue(container, valuesAttribute, modelContext);
    }

    public static <A extends Annotation, C extends Annotation> A getUsage(AnnotationDescriptor<A> type, Map<Class<? extends Annotation>, ? extends Annotation> usageMap, ModelsContext modelContext) {
        Object containerUsage;
        AnnotationDescriptor<?> repeatableContainer;
        A found = AnnotationUsageHelper.findUsage(type, usageMap);
        if (found == null && (repeatableContainer = type.getRepeatableContainer()) != null && (containerUsage = AnnotationUsageHelper.findUsage(repeatableContainer, usageMap)) != null) {
            Object[] repeatedValues = AnnotationUsageHelper.extractRepeatedValues(containerUsage, repeatableContainer, (ModelsContext)modelContext);
            if (CollectionHelper.isEmpty(repeatedValues)) {
                return null;
            }
            if (repeatedValues.length > 1) {
                throw new AnnotationAccessException("Found more than one usage of " + type.getAnnotationType().getName());
            }
            return (A)repeatedValues[0];
        }
        return found;
    }

    public static <A extends Annotation, C extends Annotation> void forEachRepeatedAnnotationUsages(Class<A> repeatableType, Class<C> containerType, Consumer<A> consumer, Map<Class<? extends Annotation>, ? extends Annotation> usageMap, ModelsContext modelContext) {
        Annotation container;
        Annotation repeatable = usageMap.get(repeatableType);
        if (repeatable != null) {
            consumer.accept(repeatable);
        }
        if ((container = usageMap.get(containerType)) != null) {
            AnnotationDescriptor<C> containerDescriptor = modelContext.getAnnotationDescriptorRegistry().getDescriptor(containerType);
            AttributeDescriptor attribute = containerDescriptor.getAttribute("value");
            Annotation[] repetitions = (Annotation[])AnnotationHelper.extractValue(container, attribute);
            CollectionHelper.forEach(repetitions, consumer);
        }
    }

    public static <A extends Annotation> void forEachRepeatedAnnotationUsages(AnnotationDescriptor<A> repeatableDescriptor, Consumer<A> consumer, Map<Class<? extends Annotation>, ? extends Annotation> usageMap, ModelsContext modelContext) {
        Class<?> containerType;
        Annotation container;
        Annotation repeatable = usageMap.get(repeatableDescriptor.getAnnotationType());
        if (repeatable != null) {
            consumer.accept(repeatable);
        }
        if ((container = usageMap.get(containerType = repeatableDescriptor.getRepeatableContainer().getAnnotationType())) != null) {
            AnnotationDescriptor<?> containerDescriptor = modelContext.getAnnotationDescriptorRegistry().getDescriptor(containerType);
            AttributeDescriptor attribute = containerDescriptor.getAttribute("value");
            Annotation[] repetitions = (Annotation[])AnnotationHelper.extractValue(container, attribute);
            CollectionHelper.forEach(repetitions, consumer);
        }
    }

    public static <A extends Annotation> A[] getRepeatedUsages(AnnotationDescriptor<A> type, Map<Class<? extends Annotation>, ? extends Annotation> usageMap, ModelsContext modelContext) {
        AttributeDescriptor attribute;
        Object[] repeatableValues;
        Annotation containerUsage;
        A usage = AnnotationUsageHelper.findUsage(type, usageMap);
        Annotation a = containerUsage = type.getRepeatableContainer() != null ? (Annotation)AnnotationUsageHelper.findUsage(type.getRepeatableContainer(), usageMap) : null;
        if (containerUsage != null && CollectionHelper.isNotEmpty(repeatableValues = (Annotation[])AnnotationHelper.extractValue(containerUsage, attribute = type.getRepeatableContainer().getAttribute("value")))) {
            if (usage != null) {
                Annotation[] combined = (Annotation[])Array.newInstance(type.getAnnotationType(), repeatableValues.length + 1);
                combined[0] = usage;
                System.arraycopy(repeatableValues, 0, combined, 1, repeatableValues.length);
                return combined;
            }
            return repeatableValues;
        }
        if (usage != null) {
            Annotation[] singleton = (Annotation[])Array.newInstance(type.getAnnotationType(), 1);
            singleton[0] = usage;
            return singleton;
        }
        return (Annotation[])Array.newInstance(type.getAnnotationType(), 0);
    }

    public static <A extends Annotation, C extends Annotation> A getNamedUsage(AnnotationDescriptor<A> descriptor, String matchValue, String attributeToMatch, Map<Class<? extends Annotation>, ?> usageMap, ModelsContext modelContext) {
        Annotation containerUsage;
        Annotation annotationUsage = (Annotation)usageMap.get(descriptor.getAnnotationType());
        if (annotationUsage != null) {
            if (AnnotationUsageHelper.nameMatches(annotationUsage, descriptor, matchValue, attributeToMatch, modelContext)) {
                return (A)annotationUsage;
            }
            return null;
        }
        AnnotationDescriptor<?> containerType = descriptor.getRepeatableContainer();
        if (containerType != null && (containerUsage = (Annotation)usageMap.get(containerType.getAnnotationType())) != null) {
            Annotation[] repeatedUsages = AnnotationUsageHelper.extractRepeatedValues((Annotation)containerUsage, containerType, (ModelsContext)modelContext);
            for (int i = 0; i < repeatedUsages.length; ++i) {
                Annotation repeatedUsage = repeatedUsages[i];
                if (!AnnotationUsageHelper.nameMatches(repeatedUsage, descriptor, matchValue, attributeToMatch, modelContext)) continue;
                return (A)repeatedUsage;
            }
        }
        return null;
    }

    private static <A extends Annotation> boolean nameMatches(A annotationUsage, AnnotationDescriptor<A> descriptor, String matchValue, String attributeToMatch, ModelsContext modelContext) {
        AttributeDescriptor attributeDescriptor = descriptor.getAttribute(attributeToMatch);
        String usageName = (String)AnnotationHelper.extractValue(annotationUsage, attributeDescriptor);
        return matchValue.equals(usageName);
    }

    private AnnotationUsageHelper() {
    }
}

