/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.List;
import java.util.function.Consumer;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.TwitterException;
import twitter4j.v1.GeoLocation;
import twitter4j.v1.Location;
import twitter4j.v1.ResponseList;
import twitter4j.v1.Trends;
import twitter4j.v1.TrendsResources;

class TrendsResourcesImpl
extends APIResourceBase
implements TrendsResources {
    TrendsResourcesImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
    }

    @Override
    public Trends getPlaceTrends(int woeid) throws TwitterException {
        return this.factory.createTrends(this.get(this.restBaseURL + "trends/place.json?id=" + woeid));
    }

    @Override
    public ResponseList<Location> getAvailableTrends() throws TwitterException {
        return this.factory.createLocationList(this.get(this.restBaseURL + "trends/available.json"));
    }

    @Override
    public ResponseList<Location> getClosestTrends(GeoLocation location) throws TwitterException {
        return this.factory.createLocationList(this.get(this.restBaseURL + "trends/closest.json", new HttpParameter("lat", location.latitude), new HttpParameter("long", location.longitude)));
    }
}

