/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public class MultipleWhitespaceRule
extends TextLevelRule {
    public MultipleWhitespaceRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public String getId() {
        return "WHITESPACE_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_whitespacerepetition");
    }

    private static boolean isFirstWhite(AnalyzedTokenReadings token) {
        return (token.isWhitespace() || StringTools.isNonBreakingWhitespace(token.getToken())) && !token.isLinebreak() && !token.getToken().contains("\u200b") && !token.getToken().contains("\ufeff") && !token.getToken().contains("\u2060");
    }

    private static boolean isRemovableWhite(AnalyzedTokenReadings token) {
        return (token.isWhitespace() || StringTools.isNonBreakingWhitespace(token.getToken())) && !token.isLinebreak() && !token.getToken().equals("\t") && !token.getToken().contains("\u200b") && !token.getToken().contains("\ufeff") && !token.getToken().contains("\u2060");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            for (int i = 1; i < tokens.length; ++i) {
                if (MultipleWhitespaceRule.isFirstWhite(tokens[i])) {
                    int nFirst = i++;
                    while (i < tokens.length && MultipleWhitespaceRule.isRemovableWhite(tokens[i])) {
                        ++i;
                    }
                    if (--i <= nFirst) continue;
                    String message = this.messages.getString("whitespace_repetition");
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + tokens[nFirst].getStartPos(), pos + tokens[i].getEndPos(), message);
                    ruleMatch.setSuggestedReplacement(tokens[nFirst].getToken());
                    ruleMatches.add(ruleMatch);
                    continue;
                }
                if (!tokens[i].isLinebreak()) continue;
                ++i;
                while (i < tokens.length && MultipleWhitespaceRule.isRemovableWhite(tokens[i])) {
                    ++i;
                }
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

