/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.api;

import com.intellij.rt.coverage.data.SingleTrFileDiscoveryProtocolDataListener;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TestDiscoveryProtocolUtil {
    /*
     * WARNING - void declaration
     */
    public static void readFile(File file, TestDiscoveryProtocolReader reader) throws IOException {
        void var1_1;
        void var2_2;
        File file2;
        int bufferSize = Integer.parseInt(System.getProperty("org.jetbrains.instrumentation.trace.file.buffer.size", "32768"));
        TestDiscoveryProtocolUtil.readSequentially(new BufferedInputStream(new FileInputStream(file2), (int)var2_2), (TestDiscoveryProtocolReader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void readSequentially(InputStream testDiscoveryDataStream, TestDiscoveryProtocolReader reader) throws IOException {
        InputStream input = new DataInputStream(testDiscoveryDataStream);
        byte start = 1;
        Integer version = null;
        while (true) {
            int read;
            if ((read = ((FilterInputStream)input).read()) == -1) {
                reader.debug("stream ended before finish marker received");
                ((FilterInputStream)input).close();
                return;
            }
            byte msgType = (byte)read;
            switch (msgType) {
                case 1: {
                    start = ((DataInputStream)input).readByte();
                    version = start;
                    reader.testDiscoveryDataProcessingStarted(version);
                    reader.debug("start marker, format version: " + version);
                    break;
                }
                case 0: {
                    reader.testDiscoveryDataProcessingFinished();
                    reader.debug("finish marker");
                    ((FilterInputStream)input).close();
                    return;
                }
                case 3: {
                    reader.debug("test data received");
                    assert (version != null);
                    TestDiscoveryProtocolUtil.readTestData((DataInputStream)input, reader, version);
                    break;
                }
                case 2: {
                    reader.debug("partial dictionary received");
                    TestDiscoveryProtocolUtil.readDictionary((DataInputStream)input, reader);
                    break;
                }
                case 5: {
                    reader.debug("metadata received");
                    TestDiscoveryProtocolUtil.readMetadata((DataInputStream)input, reader);
                    break;
                }
                case 6: {
                    reader.debug("class metadata received");
                    TestDiscoveryProtocolUtil.readClassMetadata((DataInputStream)input, reader);
                    break;
                }
                case 73: {
                    byte[] jtc = new byte[3];
                    if (start == 0) {
                        throw new IllegalStateException("File header is not expected here");
                    }
                    if (((DataInputStream)input).read(jtc) != 3) {
                        throw new IOException("Failed to read header fully");
                    }
                    if (!Arrays.equals(jtc, SingleTrFileDiscoveryProtocolDataListener.HEADER_TAIL)) {
                        reader.error("File header mismatch: I" + new String(jtc, "ASCII"));
                    }
                    reader.debug("file header");
                    break;
                }
                default: {
                    void var4_4;
                    reader.error(String.format("Unknown input: %2X", (byte)var4_4));
                }
            }
            start = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readMetadata(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        TestDiscoveryProtocolReader.MetadataReader metadataReader = reader.createMetadataReader();
        int count = CoverageIOUtil.readINT(input);
        if (count == 0) {
            return;
        }
        while (count-- > 0) {
            void var3_3;
            String key = CoverageIOUtil.readUTFFast(input);
            String value = CoverageIOUtil.readUTFFast(input);
            metadataReader.processMetadataEntry((String)var3_3, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readClassMetadata(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        TestDiscoveryProtocolReader.ClassMetadataReader metadataReader = reader.createClassMetadataReader();
        int classesCount = CoverageIOUtil.readINT(input);
        if (classesCount == 0) {
            return;
        }
        while (classesCount-- > 0) {
            void var3_3;
            int classId = CoverageIOUtil.readINT(input);
            if (metadataReader != null) {
                metadataReader.classStarted(classId);
            }
            int filesCount = CoverageIOUtil.readINT(input);
            while (filesCount-- > 0) {
                int fileId = CoverageIOUtil.readINT(input);
                if (metadataReader == null) continue;
                metadataReader.file(fileId);
            }
            int methodsCount = CoverageIOUtil.readINT(input);
            while (methodsCount-- > 0) {
                int methodId = CoverageIOUtil.readINT(input);
                int hashLength = CoverageIOUtil.readINT(input);
                byte[] hash = new byte[hashLength];
                int read = input.read(hash);
                assert (read == hashLength);
                if (metadataReader == null) continue;
                metadataReader.method(methodId, hash);
            }
            if (metadataReader == null) continue;
            metadataReader.classFinished((int)var3_3);
        }
        if (metadataReader != null) {
            void var1_1;
            var1_1.finished();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readDictionary(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        TestDiscoveryProtocolReader.NameEnumeratorReader nameEnumeratorReader = reader.createNameEnumeratorReader();
        int count = CoverageIOUtil.readINT(input);
        while (count-- > 0) {
            void var3_3;
            int id = CoverageIOUtil.readINT(input);
            String name = CoverageIOUtil.readUTFFast(input);
            nameEnumeratorReader.enumerate(name, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readTestData(DataInputStream input, TestDiscoveryProtocolReader reader, int protocolVersion) throws IOException {
        void var1_1;
        void var2_2;
        int testClassName = CoverageIOUtil.readINT(input);
        int testMethodName = CoverageIOUtil.readINT(input);
        TestDiscoveryProtocolReader.TestDataReader testDataReader = reader.createTestDataReader(testClassName, testMethodName);
        int classCount = CoverageIOUtil.readINT(input);
        while (classCount-- > 0) {
            int classId = CoverageIOUtil.readINT(input);
            int methodCount = CoverageIOUtil.readINT(input);
            testDataReader.classProcessingStarted(classId);
            while (methodCount-- > 0) {
                int methodId = CoverageIOUtil.readINT(input);
                testDataReader.processUsedMethod(methodId);
            }
            testDataReader.classProcessingFinished(classId);
        }
        if (var2_2 >= 3) {
            int filesCount = CoverageIOUtil.readINT(input);
            while (filesCount-- > 0) {
                TestDiscoveryProtocolUtil.readFile(input, testDataReader);
            }
        }
        var1_1.testDataProcessed();
    }

    /*
     * WARNING - void declaration
     */
    private static void readFile(DataInputStream input, TestDiscoveryProtocolReader.TestDataReader testDataReader) throws IOException {
        void var3_3;
        void var1_1;
        int count;
        int[] chunks = new int[count];
        int len = count;
        for (count = CoverageIOUtil.readINT(input); count > 0; --count) {
            int i;
            chunks[len - count] = i = CoverageIOUtil.readINT(input);
        }
        var1_1.processAffectedFile((int[])var3_3);
    }
}

