/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.reporters.XMLStringBuffer;

public class XmlRun {
    private List<String> m_excludes = Lists.newArrayList();
    private List<String> m_includes = Lists.newArrayList();

    public String toXml(String indent) {
        boolean hasElements;
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        boolean bl = hasElements = CollectionUtils.hasElements(this.m_excludes) || CollectionUtils.hasElements(this.m_includes);
        if (hasElements) {
            xsb.push("run");
        }
        for (String s : this.m_includes) {
            xsb.addEmptyElement("include", "name", s);
        }
        for (String s : this.m_excludes) {
            xsb.addEmptyElement("exclude", "name", s);
        }
        if (hasElements) {
            xsb.pop("run");
        }
        return xsb.toXML();
    }

    public List<String> getExcludes() {
        return this.m_excludes;
    }

    public void onExclude(String name) {
        this.m_excludes.add(name);
    }

    public List<String> getIncludes() {
        return this.m_includes;
    }

    public void onInclude(String name) {
        this.m_includes.add(name);
    }
}

