/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.InsertPointCmd;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.Unit;

public class AverageSelection
extends GenericFunction {
    public AverageSelection(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "menu.range.average";
    }

    @Override
    public void begin() {
        Selection selection = this._app.getTrackInfo().getSelection();
        DataPoint dataPoint = this.average(this._app.getTrackInfo().getTrack(), selection.getStart(), selection.getEnd());
        if (dataPoint != null) {
            InsertPointCmd insertPointCmd = new InsertPointCmd(dataPoint, -1);
            insertPointCmd.setDescription(I18nManager.getText("undo.createpoint"));
            insertPointCmd.setConfirmText(I18nManager.getText("confirm.createpoint"));
            this._app.execute(insertPointCmd);
        }
    }

    private DataPoint average(Track track, int n, int n2) {
        if (n < 0 || n >= track.getNumPoints() || n2 <= n) {
            return null;
        }
        DataPoint dataPoint = track.getPoint(n);
        double d = dataPoint.getLatitude().getDouble();
        double d2 = dataPoint.getLongitude().getDouble();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = 0;
        Unit unit = null;
        int n4 = n;
        while (n4 <= n2) {
            DataPoint dataPoint2 = track.getPoint(n4);
            if (dataPoint2 == null) break;
            d3 += dataPoint2.getLatitude().getDouble() - d;
            d4 += dataPoint2.getLongitude().getDouble() - d2;
            if (dataPoint2.hasAltitude()) {
                d5 += dataPoint2.getAltitude().getValue(unit);
                if (unit == null) {
                    unit = dataPoint2.getAltitude().getUnit();
                }
                ++n3;
            }
            ++n4;
        }
        n4 = n2 - n + 1;
        double d6 = d + d3 / (double)n4;
        double d7 = d2 + d4 / (double)n4;
        Altitude altitude = null;
        if (n3 > 0) {
            altitude = new Altitude(d5 / (double)n3, unit);
        }
        DataPoint dataPoint3 = new DataPoint(Latitude.make(d6), Longitude.make(d7), altitude);
        dataPoint3.setSegmentStart(true);
        return dataPoint3;
    }
}

