/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.symbol.EquateDBAdapterV0;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class EquateDBAdapter {
    static final String EQUATES_TABLE_NAME = "Equates";
    static final Schema EQUATES_SCHEMA = new Schema(0, "Key", new Field[]{StringField.INSTANCE, LongField.INSTANCE}, new String[]{"Equate Name", "Equate Value"});
    static final int NAME_COL = 0;
    static final int VALUE_COL = 1;

    EquateDBAdapter() {
    }

    static EquateDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new EquateDBAdapterV0(dbHandle, true);
        }
        return new EquateDBAdapterV0(dbHandle, false);
    }

    abstract long getRecordKey(String var1) throws IOException, NotFoundException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract void removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract DBRecord createEquate(String var1, long var2) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean hasRecord(String var1) throws IOException;
}

