/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slghpatexpress.OperandValue;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.SpecificSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;
import java.util.ArrayList;

public class OperandSymbol
extends SpecificSymbol {
    public static final int code_address = 1;
    public static final int offset_irrel = 2;
    public static final int variable_len = 4;
    public static final int marked = 8;
    public int reloffset;
    public int offsetbase;
    int minimumlength;
    int hand;
    OperandValue localexp;
    private TripleSymbol triple;
    private PatternExpression defexp;
    private int flags;

    public OperandSymbol(Location location) {
        super(location);
    }

    public int getRelativeOffset() {
        return this.reloffset;
    }

    public int getOffsetBase() {
        return this.offsetbase;
    }

    public int getMinimumLength() {
        return this.minimumlength;
    }

    public PatternExpression getDefiningExpression() {
        return this.defexp;
    }

    public TripleSymbol getDefiningSymbol() {
        return this.triple;
    }

    public int getIndex() {
        return this.hand;
    }

    public void setCodeAddress() {
        this.flags |= 1;
    }

    public boolean isCodeAddress() {
        return (this.flags & 1) != 0;
    }

    public void setOffsetIrrelevant() {
        this.flags |= 2;
    }

    public boolean isOffsetIrrelevant() {
        return (this.flags & 2) != 0;
    }

    public void setVariableLength() {
        this.flags |= 4;
    }

    public boolean isVariableLength() {
        return (this.flags & 4) != 0;
    }

    public void setMark() {
        this.flags |= 8;
    }

    public void clearMark() {
        this.flags &= 0xFFFFFFF7;
    }

    public boolean isMarked() {
        return (this.flags & 8) != 0;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.localexp;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.operand_symbol;
    }

    public OperandSymbol(Location location, String nm, int index, Constructor ct) {
        super(location, nm);
        this.flags = 0;
        this.hand = index;
        this.localexp = new OperandValue(location, index, ct);
        this.localexp.layClaim();
        this.defexp = null;
        this.triple = null;
    }

    public void defineOperand(PatternExpression pe) {
        if (this.defexp != null || this.triple != null) {
            throw new SleighError("Redefining operand from " + String.valueOf(pe.location), this.getLocation());
        }
        this.defexp = pe;
        this.defexp.layClaim();
    }

    public void defineOperand(TripleSymbol tri) {
        if (this.defexp != null || this.triple != null) {
            throw new SleighError("Redefining operand " + tri.getName() + " from " + String.valueOf(tri.getLocation()), this.getLocation());
        }
        this.triple = tri;
    }

    @Override
    public void dispose() {
        PatternExpression.release(this.localexp);
        if (this.defexp != null) {
            PatternExpression.release(this.defexp);
        }
    }

    @Override
    public VarnodeTpl getVarnode() {
        if (this.defexp != null) {
            return new VarnodeTpl(this.location, this.hand, true);
        }
        if (this.triple instanceof SpecificSymbol) {
            return ((SpecificSymbol)this.triple).getVarnode();
        }
        if (this.triple != null && (this.triple.getType() == symbol_type.valuemap_symbol || this.triple.getType() == symbol_type.name_symbol)) {
            return new VarnodeTpl(this.location, this.hand, true);
        }
        return new VarnodeTpl(this.location, this.hand, false);
    }

    @Override
    public int getSize() {
        if (this.triple != null) {
            return this.triple.getSize();
        }
        return 0;
    }

    @Override
    public void collectLocalValues(ArrayList<Long> results) {
        if (this.triple != null) {
            this.triple.collectLocalValues(results);
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_OPERAND_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        if (this.triple != null) {
            encoder.writeUnsignedInteger(SlaFormat.ATTRIB_SUBSYM, this.triple.getId());
        }
        encoder.writeSignedInteger(SlaFormat.ATTRIB_OFF, this.reloffset);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_BASE, this.offsetbase);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_MINLEN, this.minimumlength);
        if (this.isCodeAddress()) {
            encoder.writeBool(SlaFormat.ATTRIB_CODE, true);
        }
        encoder.writeSignedInteger(SlaFormat.ATTRIB_INDEX, this.hand);
        this.localexp.encode(encoder);
        if (this.defexp != null) {
            this.defexp.encode(encoder);
        }
        encoder.closeElement(SlaFormat.ELEM_OPERAND_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_OPERAND_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_OPERAND_SYM_HEAD);
    }
}

