/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class CloneCodeViewerAction
extends DockingAction {
    private final CodeViewerProvider provider;

    public CloneCodeViewerAction(String owner, CodeViewerProvider provider) {
        super("Code Viewer Clone", owner);
        this.provider = provider;
        GIcon image = new GIcon("icon.provider.clone");
        this.setToolBarData(new ToolBarData((Icon)image, "zzzz"));
        this.setDescription("Create a snapshot (disconnected) copy of this Listing window ");
        this.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
        this.setKeyBindingData(new KeyBindingData(84, 192));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof ProgramActionContext) {
            ProgramActionContext programContext = (ProgramActionContext)context;
            return programContext.getProgram() != null;
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        this.provider.cloneWindow();
    }
}

