/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j;

import com.googlecode.d2j.Proto;
import java.util.Objects;

public class Method {
    private final String name;
    private final String owner;
    private final Proto proto;

    public Proto getProto() {
        return this.proto;
    }

    public Method(String owner, String name, String[] parameterTypes, String returnType) {
        this.owner = owner;
        this.name = name;
        this.proto = new Proto(parameterTypes, returnType);
    }

    public Method(String owner, String name, Proto proto) {
        this.owner = owner;
        this.name = name;
        this.proto = proto;
    }

    public String getDesc() {
        return this.proto.getDesc();
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String[] getParameterTypes() {
        return this.proto.getParameterTypes();
    }

    public String getReturnType() {
        return this.proto.getReturnType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        if (!Objects.equals(this.name, method.name)) {
            return false;
        }
        if (!Objects.equals(this.owner, method.owner)) {
            return false;
        }
        return this.proto.equals(method.proto);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + this.proto.hashCode();
        return result;
    }

    public String toString() {
        return this.getOwner() + "->" + this.getName() + this.getDesc();
    }
}

