/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jungrapht.visualization.DefaultVisualizationServer;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.transform.MutableAffineTransformer;

public class VisualizationImageServer<V, E>
extends DefaultVisualizationServer<V, E> {
    Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();

    public static <V, E> Builder<V, E, ?, ?> builder(Graph<V, E> graph) {
        return new Builder(graph);
    }

    protected VisualizationImageServer(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.setSize(builder.viewSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getFullImage() {
        Dimension layoutSize = this.getVisualizationModel().getLayoutSize();
        this.setSize(layoutSize);
        AffineTransform originalViewTransform = new AffineTransform(this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        AffineTransform originalLayoutTransform = new AffineTransform(this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).getTransform());
        this.renderContext.getMultiLayerTransformer().setToIdentity();
        try {
            BufferedImage bi = new BufferedImage(layoutSize.width, layoutSize.height, 1);
            Graphics2D graphics = bi.createGraphics();
            graphics.setRenderingHints(this.renderingHints);
            this.paint(graphics);
            graphics.dispose();
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
        finally {
            this.renderContext.getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, new MutableAffineTransformer(originalViewTransform));
            this.renderContext.getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, new MutableAffineTransformer(originalLayoutTransform));
        }
    }

    public static class Builder<V, E, T extends VisualizationImageServer<V, E>, B extends Builder<V, E, T, B>>
    extends VisualizationServer.Builder<V, E, T, B> {
        protected Builder(Graph<V, E> graph) {
            super(graph);
        }

        @Override
        public T build() {
            return (T)new VisualizationImageServer(this);
        }
    }
}

