/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.AbstractSQLFunctionDatabase;
import ghidra.features.bsim.query.description.ExecutableRecord;
import java.sql.SQLException;

public abstract class IDSQLResolution {
    public long id1;
    public long id2;

    public abstract void resolve(AbstractSQLFunctionDatabase<?> var1, ExecutableRecord var2) throws SQLException;

    public static class ExternalFunction
    extends IDSQLResolution {
        private String exeName;
        private String funcName;

        public ExternalFunction(String exe, String func) {
            this.exeName = exe;
            this.funcName = func;
            this.id1 = 0L;
        }

        @Override
        public void resolve(AbstractSQLFunctionDatabase<?> columnDatabase, ExecutableRecord exe) throws SQLException {
            try {
                if (this.id1 == 0L) {
                    this.id1 = columnDatabase.recoverExternalFunctionId(this.exeName, this.funcName, exe.getArchitecture());
                }
            }
            catch (LSHException ex) {
                throw new SQLException(ex.getMessage());
            }
        }
    }

    public static class ExeCategory
    extends IDSQLResolution {
        private String categoryString;
        private String valueString;

        public ExeCategory(String cat, String val) {
            this.categoryString = cat;
            this.valueString = val;
            this.id1 = 0L;
            this.id2 = 0L;
        }

        @Override
        public void resolve(AbstractSQLFunctionDatabase<?> columnDatabase, ExecutableRecord exe) throws SQLException {
            if (this.id1 == 0L) {
                this.id1 = columnDatabase.queryCategoryString(this.categoryString);
                this.id2 = columnDatabase.queryCategoryString(this.valueString);
            }
        }
    }

    public static class Compiler
    extends IDSQLResolution {
        private String compilerName;

        public Compiler(String nm) {
            this.compilerName = nm;
            this.id1 = 0L;
        }

        @Override
        public void resolve(AbstractSQLFunctionDatabase<?> columnDatabase, ExecutableRecord exe) throws SQLException {
            if (this.id1 == 0L) {
                this.id1 = columnDatabase.queryCompilerString(this.compilerName);
            }
        }
    }

    public static class Architecture
    extends IDSQLResolution {
        private String archName;

        public Architecture(String nm) {
            this.archName = nm;
            this.id1 = 0L;
        }

        @Override
        public void resolve(AbstractSQLFunctionDatabase<?> columnDatabase, ExecutableRecord exe) throws SQLException {
            if (this.id1 == 0L) {
                this.id1 = columnDatabase.queryArchString(this.archName);
            }
        }
    }
}

