/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.AbstractSession;
import org.jkiss.dbeaver.model.net.ssh.JSCHSessionController;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class JSCHSession
extends AbstractSession {
    private final JSCHSessionController controller;
    private Session session;

    public JSCHSession(@NotNull JSCHSessionController controller) {
        this.controller = controller;
    }

    public void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration destination, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        this.session = this.controller.createNewSession(monitor, configuration, destination);
    }

    public void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) {
        this.session.disconnect();
        this.session = null;
    }

    @NotNull
    public SSHPortForwardConfiguration setupPortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
        try {
            int port = this.session.setPortForwardingL(configuration.localHost(), configuration.localPort(), configuration.remoteHost(), configuration.remotePort());
            return new SSHPortForwardConfiguration(configuration.localHost(), port, configuration.remoteHost(), configuration.remotePort());
        }
        catch (JSchException e) {
            throw new DBException("Unable to set up port forwarding", (Throwable)e);
        }
    }

    public void removePortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
        if (!this.session.isConnected()) {
            return;
        }
        try {
            this.session.delPortForwardingL(configuration.localHost(), configuration.localPort());
        }
        catch (JSchException e) {
            throw new DBException("Unable to remove port forwarding", (Throwable)e);
        }
    }

    public void getFile(@NotNull String src, @NotNull OutputStream dst, @NotNull DBRProgressMonitor monitor) throws IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.get(src, dst, (SftpProgressMonitor)new SftpProgressMonitorAdapter(monitor));
        }
        catch (SftpException e) {
            throw new IOException("Error downloading file through SFTP channel", e);
        }
        finally {
            channel.disconnect();
        }
    }

    public void putFile(@NotNull InputStream src, @NotNull String dst, @NotNull DBRProgressMonitor monitor) throws IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.put(src, dst, (SftpProgressMonitor)new SftpProgressMonitorAdapter(monitor));
        }
        catch (SftpException e) {
            throw new IOException("Error uploading file through SFTP channel", e);
        }
        finally {
            channel.disconnect();
        }
    }

    @NotNull
    public String getClientVersion() {
        return this.session.getClientVersion();
    }

    @NotNull
    public String getServerVersion() {
        return this.session.getServerVersion();
    }

    @NotNull
    private ChannelSftp openSftpChannel() throws IOException {
        ChannelSftp channel;
        try {
            channel = (ChannelSftp)this.session.openChannel("sftp");
            channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("Error opening SFTP channel", e);
        }
        return channel;
    }

    private record SftpProgressMonitorAdapter(@NotNull DBRProgressMonitor delegate) implements SftpProgressMonitor
    {
        public void init(int op, String src, String dst, long max) {
            if (op == 0) {
                this.delegate.beginTask(NLS.bind((String)"Upload file ''{0}'' -> ''{1}''", (Object)src, (Object)dst), (int)max);
            } else {
                this.delegate.beginTask(NLS.bind((String)"Download file ''{0}'' -> ''{1}''", (Object)src, (Object)dst), (int)max);
            }
        }

        public boolean count(long count) {
            this.delegate.worked((int)count);
            return !this.delegate.isCanceled();
        }

        public void end() {
            this.delegate.done();
        }
    }
}

