/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.password;

import java.io.Console;
import java.util.IllegalFormatException;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;

public class ConsolePasswordFinder
implements PasswordFinder {
    public static final String DEFAULT_FORMAT = "Enter passphrase for %s:";
    private final Console console;
    private final String promptFormat;
    private final int maxTries;
    private int numTries;

    public ConsolePasswordFinder() {
        this(System.console());
    }

    public ConsolePasswordFinder(Console console) {
        this(console, DEFAULT_FORMAT, 3);
    }

    public ConsolePasswordFinder(Console console, String promptFormat, int maxTries) {
        ConsolePasswordFinder.checkFormatString(promptFormat);
        this.console = console;
        this.promptFormat = promptFormat;
        this.maxTries = maxTries;
        this.numTries = 0;
    }

    @Override
    public char[] reqPassword(Resource<?> resource) {
        ++this.numTries;
        if (this.console == null) {
            return null;
        }
        return this.console.readPassword(this.promptFormat, resource.toString());
    }

    @Override
    public boolean shouldRetry(Resource<?> resource) {
        return this.numTries < this.maxTries;
    }

    private static void checkFormatString(String promptFormat) {
        try {
            String.format(promptFormat, "");
        }
        catch (IllegalFormatException e) {
            throw new IllegalArgumentException("promptFormat must have no more than one %s and no other markers", e);
        }
    }
}

