/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.DataGetter;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001b*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u001a\u001bB+\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\tj\u0002`\u00160\u0015H\u0007J\u0016\u0010\u0017\u001a\u00020\u00132\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000fJ\u0016\u0010\u0019\u001a\u00020\u00132\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/ui/frame/CommitDetailsLoader;", "D", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "", "commitDetailsGetter", "Lcom/intellij/vcs/log/data/DataGetter;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "limit", "", "<init>", "(Lcom/intellij/vcs/log/data/DataGetter;Lcom/intellij/openapi/Disposable;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/vcs/log/ui/frame/CommitDetailsLoader$Listener;", "lastRequest", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadDetails", "", "commitIds", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "addListener", "listener", "removeListener", "Listener", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCommitDetailsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitDetailsLoader.kt\ncom/intellij/vcs/log/ui/frame/CommitDetailsLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1869#2,2:95\n1869#2,2:97\n1869#2,2:99\n1869#2,2:101\n1869#2,2:103\n1869#2,2:105\n1869#2,2:107\n1869#2,2:109\n*S KotlinDebug\n*F\n+ 1 CommitDetailsLoader.kt\ncom/intellij/vcs/log/ui/frame/CommitDetailsLoader\n*L\n44#1:95,2\n45#1:97,2\n48#1:99,2\n49#1:101,2\n60#1:103,2\n61#1:105,2\n67#1:107,2\n68#1:109,2\n*E\n"})
public final class CommitDetailsLoader<D extends VcsCommitMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGetter<D> commitDetailsGetter;
    @Nullable
    private final Integer limit;
    @NotNull
    private final CopyOnWriteArrayList<Listener<? super D>> listeners;
    @Nullable
    private ProgressIndicator lastRequest;
    @NotNull
    private static final Logger LOG;

    @JvmOverloads
    public CommitDetailsLoader(@NotNull DataGetter<D> commitDetailsGetter, @NotNull Disposable parentDisposable, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter(commitDetailsGetter, (String)"commitDetailsGetter");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.commitDetailsGetter = commitDetailsGetter;
        this.limit = limit;
        this.listeners = new CopyOnWriteArrayList();
        Disposer.register((Disposable)parentDisposable, () -> CommitDetailsLoader._init_$lambda$0(this));
    }

    public /* synthetic */ CommitDetailsLoader(DataGetter dataGetter, Disposable disposable2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(dataGetter, disposable2, n);
    }

    @RequiresEdt
    public final void loadDetails(@NotNull List<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        ProgressIndicator progressIndicator = this.lastRequest;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        this.lastRequest = null;
        Integer n = this.limit;
        List<Integer> commitIds3 = commitIds2.subList(0, n != null ? RangesKt.coerceAtMost((int)n, (int)commitIds2.size()) : commitIds2.size());
        if (commitIds3.isEmpty()) {
            Listener it;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onLoadingStopped();
            }
            $this$forEach$iv = this.listeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onEmptySelection();
            }
        } else {
            Listener it;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onSelection();
            }
            $this$forEach$iv = this.listeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onLoadingStarted();
            }
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            this.lastRequest = (ProgressIndicator)indicator;
            this.commitDetailsGetter.loadCommitsData(commitIds3, arg_0 -> CommitDetailsLoader.loadDetails$lambda$4(this, indicator, commitIds3, arg_0), (Consumer<Throwable>)((Consumer)arg_0 -> CommitDetailsLoader.loadDetails$lambda$5(this, indicator, commitIds3, arg_0)), (ProgressIndicator)indicator);
        }
    }

    public final void addListener(@NotNull Listener<? super D> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener<? super D> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @JvmOverloads
    public CommitDetailsLoader(@NotNull DataGetter<D> commitDetailsGetter, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(commitDetailsGetter, (String)"commitDetailsGetter");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(commitDetailsGetter, parentDisposable, null, 4, null);
    }

    private static final void _init_$lambda$0(CommitDetailsLoader this$0) {
        ProgressIndicator progressIndicator = this$0.lastRequest;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        this$0.lastRequest = null;
    }

    private static final void loadDetails$lambda$4(CommitDetailsLoader this$0, EmptyProgressIndicator $indicator, List $commitIds, List detailsList) {
        Intrinsics.checkNotNullParameter((Object)detailsList, (String)"detailsList");
        if (this$0.lastRequest == $indicator && !$indicator.isCanceled()) {
            Listener it;
            if ($commitIds.size() != detailsList.size()) {
                LOG.error("Loaded incorrect number of details " + detailsList + " for commits " + $commitIds);
            }
            this$0.lastRequest = null;
            Iterable $this$forEach$iv = this$0.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onDetailsLoaded($commitIds, detailsList);
            }
            $this$forEach$iv = this$0.listeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onLoadingStopped();
            }
        }
    }

    private static final void loadDetails$lambda$5(CommitDetailsLoader this$0, EmptyProgressIndicator $indicator, List $commitIds, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this$0.lastRequest == $indicator && !$indicator.isCanceled()) {
            Listener it;
            this$0.lastRequest = null;
            LOG.error("Error loading details for commits " + $commitIds, t);
            Iterable $this$forEach$iv = this$0.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onError(t);
            }
            $this$forEach$iv = this$0.listeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Listener)element$iv;
                boolean bl = false;
                it.onLoadingStopped();
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(CommitDetailsLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/ui/frame/CommitDetailsLoader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J(\u0010\t\u001a\u00020\u00052\u0010\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/ui/frame/CommitDetailsLoader$Listener;", "D", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Ljava/util/EventListener;", "onLoadingStarted", "", "onLoadingStopped", "onEmptySelection", "onSelection", "onDetailsLoaded", "commitIds", "", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "details", "onError", "error", "", "intellij.platform.vcs.log.impl"})
    public static interface Listener<D extends VcsCommitMetadata>
    extends EventListener {
        default public void onLoadingStarted() {
        }

        default public void onLoadingStopped() {
        }

        default public void onEmptySelection() {
        }

        default public void onSelection() {
        }

        default public void onDetailsLoaded(@NotNull List<Integer> commitIds2, @NotNull List<? extends D> details) {
            Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
            Intrinsics.checkNotNullParameter(details, (String)"details");
        }

        default public void onError(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        }
    }
}

