/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import git4idea.branch.GitBranchPair;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateConfigurable;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateSession;
import git4idea.update.HashRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitUpdateEnvironment
implements UpdateEnvironment {
    private final Project myProject;

    public GitUpdateEnvironment(@NotNull Project project) {
        if (project == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(FilePath @NotNull [] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> sequentialUpdatesContextRef) throws ProcessCanceledException {
        if (sequentialUpdatesContextRef == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(1);
        }
        if (filePaths == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(2);
        }
        UpdateSession updateSession = GitUpdateEnvironment.performUpdate(this.myProject, filePaths, updatedFiles, progressIndicator, GitVcsSettings.getInstance(this.myProject).getUpdateMethod(), null);
        if (updateSession == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(3);
        }
        return updateSession;
    }

    public boolean validateOptions(Collection<FilePath> filePaths) {
        return true;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return new GitUpdateConfigurable(GitVcsSettings.getInstance(this.myProject));
    }

    public boolean hasCustomNotification() {
        boolean keepLogUpToDate = VcsLogManager.keepUpToDate();
        return Registry.is((String)"git.update.project.info.as.log") && keepLogUpToDate;
    }

    @ApiStatus.Internal
    public static UpdateSession performUpdate(Project project, FilePath[] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, UpdateMethod updateMethod, Map<GitRepository, GitBranchPair> updateConfig) {
        GitRepositoryManager manager2 = GitRepositoryManager.getInstance(project);
        Set repositories = ContainerUtil.map2SetNotNull(Arrays.asList(filePaths), arg_0 -> ((GitRepositoryManager)manager2).getRepositoryForFile(arg_0));
        GitUpdateProcess gitUpdateProcess = new GitUpdateProcess(project, progressIndicator, repositories, updatedFiles, updateConfig, true, true);
        boolean result2 = gitUpdateProcess.update(updateMethod).isSuccess();
        Map<GitRepository, HashRange> updatedRanges = gitUpdateProcess.getUpdatedRanges();
        GitUpdateInfoAsLog.NotificationData notificationData = updatedRanges != null ? new GitUpdateInfoAsLog(project, updatedRanges).calculateDataAndCreateLogTab() : null;
        return new GitUpdateSession(project, notificationData, result2, gitUpdateProcess.getSkippedRoots());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequentialUpdatesContextRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdateEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdateEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

