/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog.view;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntryWithDetails;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditor;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditorKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0013\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J4\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0005\u001a\u00020%2\b\u0010\u000b\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0016J\b\u0010+\u001a\u00020\u001bH\u0002J\r\u0010,\u001a\u00070-\u00a2\u0006\u0002\b.H\u0016J\u0012\u0010/\u001a\u00020(2\b\u00100\u001a\u0004\u0018\u000101H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellEditor;", "project", "Lcom/intellij/openapi/project/Project;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;Lcom/intellij/openapi/Disposable;)V", "value", "", "savedHeight", "getSavedHeight", "()I", "setSavedHeight", "(I)V", "closeEditorAction", "git4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$closeEditorAction$1", "Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$closeEditorAction$1;", "commitMessageForEntry", "", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "lastUsedCommitMessageField", "hint", "Ljavax/swing/JLabel;", "createCommitMessage", "registerCloseEditorShortcut", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "shortcut", "Ljavax/swing/KeyStroke;", "getTableCellEditorComponent", "Ljava/awt/Component;", "Ljavax/swing/JTable;", "", "isSelected", "", "row", "column", "createHint", "getCellEditorValue", "", "Lorg/jetbrains/annotations/NotNull;", "isCellEditable", "e", "Ljava/util/EventObject;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nCommitMessageCellEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitMessageCellEditor.kt\ngit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,182:1\n382#2,7:183\n*S KotlinDebug\n*F\n+ 1 CommitMessageCellEditor.kt\ngit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor\n*L\n97#1:183,7\n*E\n"})
public final class CommitMessageCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRebaseCommitsTableView table;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final closeEditorAction.1 closeEditorAction;
    @NotNull
    private final Map<GitRebaseEntryWithDetails, CommitMessage> commitMessageForEntry;
    @Nullable
    private CommitMessage lastUsedCommitMessageField;
    @NotNull
    private final JLabel hint;
    @NonNls
    @NotNull
    private static final String COMMIT_MESSAGE_HEIGHT_KEY = "Git.Interactive.Rebase.Dialog.Commit.Message.Height";
    private static final int HINT_HEIGHT = JBUIScale.scale((int)17);
    private static final int DEFAULT_COMMIT_MESSAGE_HEIGHT = GitRebaseCommitsTableView.Companion.getDEFAULT_CELL_HEIGHT() * 5;

    public CommitMessageCellEditor(@NotNull Project project, @NotNull GitRebaseCommitsTableView table, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.table = table;
        this.disposable = disposable;
        this.closeEditorAction = new AbstractAction(this){
            final /* synthetic */ CommitMessageCellEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.stopCellEditing();
            }
        };
        this.commitMessageForEntry = new LinkedHashMap();
        this.hint = this.createHint();
    }

    private final int getSavedHeight() {
        return PropertiesComponent.getInstance((Project)this.project).getInt(COMMIT_MESSAGE_HEIGHT_KEY, DEFAULT_COMMIT_MESSAGE_HEIGHT);
    }

    private final void setSavedHeight(int value) {
        PropertiesComponent.getInstance((Project)this.project).setValue(COMMIT_MESSAGE_HEIGHT_KEY, value, DEFAULT_COMMIT_MESSAGE_HEIGHT);
    }

    private final CommitMessage createCommitMessage() {
        CommitMessage commitMessage;
        CommitMessage $this$createCommitMessage_u24lambda_u240 = commitMessage = new CommitMessage(this.project, false, false, true);
        boolean bl = false;
        $this$createCommitMessage_u24lambda_u240.getEditorField().addSettingsProvider(arg_0 -> CommitMessageCellEditor.createCommitMessage$lambda$0$0(this, arg_0));
        $this$createCommitMessage_u24lambda_u240.getEditorField().setCaretPosition(0);
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)$this$createCommitMessage_u24lambda_u240));
        return commitMessage;
    }

    private final void registerCloseEditorShortcut(EditorEx editor2, KeyStroke shortcut) {
        String key = "applyEdit" + shortcut;
        editor2.getContentComponent().getInputMap().put(shortcut, key);
        editor2.getContentComponent().getActionMap().put(key, this.closeEditorAction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Component getTableCellEditorComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
        BorderLayoutPanel borderLayoutPanel;
        CommitMessage commitMessageField;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        GitRebaseCommitsTableModel<?> model = this.table.getModel();
        Object rebaseEntry = model.getEntry(row);
        if (!(rebaseEntry instanceof GitRebaseEntryWithDetails)) {
            return null;
        }
        Map<GitRebaseEntryWithDetails, CommitMessage> map2 = this.commitMessageForEntry;
        Object key$iv = rebaseEntry;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CommitMessage answer$iv = this.createCommitMessage();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        this.lastUsedCommitMessageField = commitMessageField = (CommitMessage)object;
        commitMessageField.setText(model.getCommitMessage(row));
        table.setRowHeight(row, this.getSavedHeight());
        BorderLayoutPanel componentPanel2 = new BorderLayoutPanel(commitMessageField){
            final /* synthetic */ CommitMessage $commitMessageField;
            {
                this.$commitMessageField = $commitMessageField;
            }

            public void requestFocus() {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> getTableCellEditorComponent.componentPanel.1.requestFocus$lambda$0(this.$commitMessageField));
            }

            private static final void requestFocus$lambda$0(CommitMessage $commitMessageField) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)$commitMessageField.getEditorField(), true);
            }
        };
        BorderLayoutPanel $this$getTableCellEditorComponent_u24lambda_u241 = borderLayoutPanel = componentPanel2.addToCenter((Component)commitMessageField).addToBottom((Component)this.hint);
        boolean bl = false;
        $this$getTableCellEditorComponent_u24lambda_u241.setBackground(table.getBackground());
        $this$getTableCellEditorComponent_u24lambda_u241.setBorder(JBUI.Borders.merge((Border)IdeBorderFactory.createBorder(), (Border)((Border)JBUI.Borders.empty((int)6, (int)0, (int)0, (int)6)), (boolean)true));
        Intrinsics.checkNotNull((Object)$this$getTableCellEditorComponent_u24lambda_u241);
        CommitMessageCellEditorKt.access$makeResizable((JPanel)$this$getTableCellEditorComponent_u24lambda_u241, arg_0 -> CommitMessageCellEditor.getTableCellEditorComponent$lambda$1$0(table, row, this, arg_0));
        return (Component)borderLayoutPanel;
    }

    private final JLabel createHint() {
        JLabel jLabel;
        Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getCtrlEnter())};
        String string = GitBundle.message("rebase.interactive.dialog.reword.hint.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String hint = string;
        JLabel $this$createHint_u24lambda_u240 = jLabel = HintUtil.createAdComponent((String)hint, (Border)JBUI.CurrentTheme.BigPopup.advertiserBorder(), (int)2);
        boolean bl = false;
        $this$createHint_u24lambda_u240.setForeground(JBUI.CurrentTheme.BigPopup.advertiserForeground());
        $this$createHint_u24lambda_u240.setBackground(JBUI.CurrentTheme.BigPopup.advertiserBackground());
        $this$createHint_u24lambda_u240.setOpaque(true);
        JLabel jLabel2 = jLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"apply(...)");
        JLabel hintLabel = jLabel2;
        Dimension size = hintLabel.getPreferredSize();
        size.height = HINT_HEIGHT;
        hintLabel.setPreferredSize(size);
        return hintLabel;
    }

    @Override
    @NotNull
    public String getCellEditorValue() {
        Object object = this.lastUsedCommitMessageField;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    public boolean isCellEditable(@Nullable EventObject e) {
        return this.table.getSelectedRowCount() > 1 ? false : (e instanceof MouseEvent ? ((MouseEvent)e).getClickCount() >= 2 : true);
    }

    private static final void createCommitMessage$lambda$0$0(CommitMessageCellEditor this$0, EditorEx editor2) {
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        Intrinsics.checkNotNull((Object)editor2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 128);
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
        this$0.registerCloseEditorShortcut(editor2, keyStroke);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 256);
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"getKeyStroke(...)");
        this$0.registerCloseEditorShortcut(editor2, keyStroke2);
    }

    private static final Unit getTableCellEditorComponent$lambda$1$0(JTable $table, int $row, CommitMessageCellEditor this$0, int newHeight) {
        int height = Math.max(DEFAULT_COMMIT_MESSAGE_HEIGHT, newHeight);
        $table.setRowHeight($row, height);
        this$0.setSavedHeight(height);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eR\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$Companion;", "", "<init>", "()V", "COMMIT_MESSAGE_HEIGHT_KEY", "", "HINT_HEIGHT", "", "DEFAULT_COMMIT_MESSAGE_HEIGHT", "canResize", "", "height", "point", "Ljava/awt/Point;", "canResize$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canResize$intellij_vcs_git(int height, @NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            int n = height - HINT_HEIGHT;
            int n2 = point.y;
            return n <= n2 ? n2 <= height : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

