/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class RolloverProducer
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private static final Logger LOG = Logger.getLogger(RolloverProducer.class.getName());
    public static final String CLICKED_KEY = "swingx.clicked";
    public static final String ROLLOVER_KEY = "swingx.rollover";
    protected Point rollover = new Point(-1, -1);

    public void install(JComponent component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addComponentListener(this);
    }

    public void release(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeComponentListener(this);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.updateRollover(e2, CLICKED_KEY, true);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.updateRollover(e2, ROLLOVER_KEY, false);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        ((JComponent)e2.getSource()).putClientProperty(ROLLOVER_KEY, null);
        ((JComponent)e2.getSource()).putClientProperty(CLICKED_KEY, null);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        this.updateRollover(e2, ROLLOVER_KEY, false);
    }

    @Override
    public void componentShown(ComponentEvent e2) {
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        this.updateRollover(e2);
    }

    @Override
    public void componentMoved(ComponentEvent e2) {
        this.updateRollover(e2);
    }

    private void updateRollover(ComponentEvent e2) {
        Point componentLocation = e2.getComponent().getMousePosition();
        if (componentLocation == null) {
            componentLocation = new Point(-1, -1);
        }
        this.updateRolloverPoint((JComponent)e2.getComponent(), componentLocation);
        this.updateClientProperty((JComponent)e2.getComponent(), ROLLOVER_KEY, true);
    }

    @Override
    public void componentHidden(ComponentEvent e2) {
    }

    protected void updateRollover(MouseEvent e2, String property, boolean fireAlways) {
        this.updateRolloverPoint((JComponent)e2.getComponent(), e2.getPoint());
        this.updateClientProperty((JComponent)e2.getComponent(), property, fireAlways);
    }

    protected void updateClientProperty(JComponent component, String property, boolean fireAlways) {
        if (fireAlways) {
            component.putClientProperty(property, null);
            component.putClientProperty(property, new Point(this.rollover));
        } else {
            Point p = (Point)component.getClientProperty(property);
            if (p == null || this.rollover.x != p.x || this.rollover.y != p.y) {
                component.putClientProperty(property, new Point(this.rollover));
            }
        }
    }

    protected abstract void updateRolloverPoint(JComponent var1, Point var2);
}

