/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DomFileIndex
extends ScalarIndexExtension<DomIndexKey> {
    private static final ID<DomIndexKey, Void> INDEX_ID = ID.create((String)"DomFileIndex");
    private static final String NULL_NAMESPACE = "-NULL-";

    @NotNull
    public ID<DomIndexKey, Void> getName() {
        ID<DomIndexKey, Void> iD = INDEX_ID;
        if (iD == null) {
            DomFileIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public static Collection<VirtualFile> findFiles(@NotNull String rootTagName, @Nullable String namespace, @NotNull GlobalSearchScope scope) {
        if (rootTagName == null) {
            DomFileIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            DomFileIndex.$$$reportNull$$$0(2);
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(INDEX_ID, (Object)new DomIndexKey(rootTagName, (String)ObjectUtils.notNull((Object)namespace, (Object)NULL_NAMESPACE)), scope);
        if (collection == null) {
            DomFileIndex.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public DataIndexer<DomIndexKey, Void, FileContent> getIndexer() {
        return new DataIndexer<DomIndexKey, Void, FileContent>(this){

            @NotNull
            public Map<DomIndexKey, Void> map(@NotNull FileContent inputData) {
                XmlFileHeader header;
                String rootTagName;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((rootTagName = (header = NanoXmlUtil.parseHeader((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()))).getRootTagLocalName()) == null) {
                    Map<DomIndexKey, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                String[] namespaces = new String[]{header.getPublicId(), header.getSystemId(), header.getRootTagNamespace(), DomFileIndex.NULL_NAMESPACE};
                HashMap<DomIndexKey, Void> set = new HashMap<DomIndexKey, Void>(namespaces.length);
                for (String t : namespaces) {
                    if (t == null) continue;
                    set.put(new DomIndexKey(rootTagName, t), null);
                }
                HashMap<DomIndexKey, Void> hashMap = set;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/xml/DomFileIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/xml/DomFileIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<DomIndexKey> getKeyDescriptor() {
        return new DomIndexKeyDescriptor();
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/DomFileIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTagName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/DomFileIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class DomIndexKey {
        @NotNull
        private final String myRootTagName;
        @NotNull
        private final String myNamespace;

        private DomIndexKey(@NotNull String rootTagName, @NotNull String namespace) {
            if (rootTagName == null) {
                DomIndexKey.$$$reportNull$$$0(0);
            }
            if (namespace == null) {
                DomIndexKey.$$$reportNull$$$0(1);
            }
            this.myRootTagName = rootTagName;
            this.myNamespace = namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomIndexKey key = (DomIndexKey)o;
            return this.myRootTagName.equals(key.myRootTagName) && this.myNamespace.equals(key.myNamespace);
        }

        public int hashCode() {
            return Objects.hash(this.myRootTagName, this.myNamespace);
        }

        public String toString() {
            return "DomIndexKey{myRootTagName='" + this.myRootTagName + "', myNamespace='" + this.myNamespace + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootTagName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/xml/DomFileIndex$DomIndexKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DomIndexKeyDescriptor
    implements KeyDescriptor<DomIndexKey> {
        private DomIndexKeyDescriptor() {
        }

        public boolean isEqual(DomIndexKey val1, DomIndexKey val2) {
            return val1.equals(val2);
        }

        public DomIndexKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                DomIndexKeyDescriptor.$$$reportNull$$$0(0);
            }
            return new DomIndexKey(EnumeratorStringDescriptor.INSTANCE.read(in), EnumeratorStringDescriptor.INSTANCE.read(in));
        }

        public int getHashCode(DomIndexKey value) {
            return value.hashCode();
        }

        public void save(@NotNull DataOutput out, DomIndexKey value) throws IOException {
            if (out == null) {
                DomIndexKeyDescriptor.$$$reportNull$$$0(1);
            }
            EnumeratorStringDescriptor.INSTANCE.save(out, value.myRootTagName);
            EnumeratorStringDescriptor.INSTANCE.save(out, value.myNamespace);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/xml/DomFileIndex$DomIndexKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

