/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.ru.RussianCrazyParseDetector;
import ai.grazie.rules.ru.RussianTreeDisambiguator;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.tools.StringTools;

@NullMarked
public class RussianTreeSupport
extends TreeSupport {
    private static final Pattern oldNounForm = Pattern.compile(".+[\u043d\u0442\u0440]\u044c[\u044f\u0435\u044e\u0438][\u0445\u043c]?|.+[\u043e\u0451]\u044e|.+\u0438\u0435\u044e");
    private static final Pattern newNounForm = Pattern.compile(".+[\u043d\u0442\u0440]\u0438\u0435|.*\u0430|.+(\u0438\u0439|\u0438\u044f[\u043c\u0445]?|.+\u043c\u044c\u044f|\u0438\u0435\u0439|\u0438\u044e)");
    private static final Pattern oldAdjForm = Pattern.compile(".+[\u043e\u0435]\u044e");
    private static final Pattern oldPronounForm = Pattern.compile(".+\u043e\u0435\u044e");
    private static final Set<String> optionalNPronouns = Set.of("\u0435\u0433\u043e", "\u0435\u043c\u0443", "\u0435\u0435", "\u0435\u0451", "\u0435\u0439", "\u0435\u044e", "\u0438\u0445", "\u0438\u043c", "\u0438\u043c\u0438");

    public RussianTreeSupport(Language language) {
        this(language, () -> null);
    }

    public RussianTreeSupport(Language language, Supplier<@Nullable WordListWithFrequency> hunspell) {
        super(language, hunspell);
        assert (language.getShortCode().equals("ru"));
    }

    @Override
    public Tree buildTree(SentenceWithTreeDependencies conllu, @Nullable SentenceWithNERAnnotations ner, @Nullable Runnable checkCancelled) {
        return new RussianTreeDisambiguator(super.buildTree(conllu, ner, checkCancelled)).disambiguateByTree();
    }

    @Override
    public CrazyParseDetector crazyParseDetector() {
        return RussianCrazyParseDetector.INSTANCE;
    }

    @Override
    public String quote(String text) {
        return "\u00ab" + text + "\u00bb";
    }

    @Override
    public boolean isTrulyLowerCase(Node node) {
        return !node.hasPos("NN:Name:.*");
    }

    @Override
    protected Tagger createTagger() {
        return RussianTreeSupport.createTagger(this.language());
    }

    static LTTagger createTagger(Language language) {
        return new LTTagger(language){

            @Override
            public List<Tree.Reading> toReadings(AnalyzedTokenReadings token) {
                String form;
                int i;
                List<Tree.Reading> normal = super.toReadings(token);
                if (token.getChunkTags().stream().anyMatch(t -> t.getChunkTag().equals("MayMissingYO")) && (i = (form = token.getToken()).indexOf(1077)) >= 0) {
                    String withYo = form.substring(0, i) + "\u0451" + form.substring(i + 1);
                    try {
                        List tagged = this.language.getTagger().tag(List.of(withYo));
                        if (tagged.size() == 1) {
                            return StreamEx.of(normal).append(super.toReadings((AnalyzedTokenReadings)tagged.getFirst())).toList();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return normal;
            }
        };
    }

    @Override
    public List<String> inflectNode(Node node, String posRegex, String posReplacement) {
        List<String> result = super.inflectNode(node, posRegex, posReplacement);
        if (node.hasLemma("\u043e\u043d[\u043e\u0430\u0438]?")) {
            return RussianTreeSupport.chooseImNim(node, result);
        }
        return result;
    }

    static List<String> chooseImNim(Node node, List<String> pronounSuggestions) {
        if (node.hasDependent("case")) {
            return pronounSuggestions.stream().filter(s -> !optionalNPronouns.contains(s)).toList();
        }
        return pronounSuggestions.stream().filter(s -> !s.startsWith("\u043d") || !optionalNPronouns.contains(s.substring(1))).toList();
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        List<String> result = super.synthesize(form, lemma, srcPos, targetPos);
        if (targetPos.contains("PL")) {
            result.remove("\u043c\u043e\u043b\u043e\u0434\u0451\u0436\u0438");
            result.remove("\u043c\u043e\u043b\u043e\u0434\u0435\u0436\u0438");
            result.remove("\u0433\u043e\u043b\u043e\u0434\u044b");
        }
        if (targetPos.contains("R")) {
            result.remove("\u0435\u0439");
            result.remove("\u043d\u0435\u0439");
        }
        result.remove("\u0441\u0430\u043c\u043e\u0451");
        result.remove("\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434");
        if (!StringTools.startsWithUppercase((String)form)) {
            result.remove("\u043b\u044e\u0431\u043e\u0432\u0438");
        }
        if (targetPos.contains("ADJ:Short:PL")) {
            result.removeIf(s -> s.matches(".*\u043d\u043d\u044b"));
        }
        if (form.toLowerCase(Locale.ROOT).equals(form)) {
            result.remove("\u0434\u0440\u0443\u0437\u044c");
        }
        if (targetPos.startsWith("NN:") && newNounForm.matcher(lemma).matches() && !oldNounForm.matcher(form).matches()) {
            result.removeIf(s -> oldNounForm.matcher((CharSequence)s).matches());
        }
        if ((targetPos.startsWith("PT:") || targetPos.startsWith("ADJ:Posit")) && !oldAdjForm.matcher(form).matches()) {
            result.removeIf(s -> oldAdjForm.matcher((CharSequence)s).matches());
        }
        if (targetPos.startsWith("ADJ:MPR:") && !oldPronounForm.matcher(form).matches()) {
            result.removeIf(s -> oldPronounForm.matcher((CharSequence)s).matches());
        }
        return result;
    }

    @Override
    public Quotes getAllQuotes() {
        return RussianTreePatterns.quotes;
    }
}

