/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PyDictKeyNamesCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final String DEFAULT_QUOTE = "\"";

    public PyDictKeyNamesCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(PySubscriptionExpression.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                DictKeyCompletionResultSet dictCompletion;
                PsiElement original;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((original = parameters.getOriginalPosition()) == null) {
                    return;
                }
                PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)original, PySubscriptionExpression.class);
                if (subscription == null) {
                    return;
                }
                PyExpression operand = subscription.getOperand();
                if (PyDictKeyNamesCompletionContributor.addCompletionIfOperandIsTypedDict(operand, dictCompletion = new DictKeyCompletionResultSet(result, subscription.getIndexExpression() instanceof PyStringLiteralExpression))) {
                    return;
                }
                if (operand instanceof PyReferenceExpression) {
                    PyExpression resolvedElement = PyResolveUtil.fullResolveLocally((PyReferenceExpression)operand);
                    if (resolvedElement instanceof PyDictLiteralExpression) {
                        PyDictKeyNamesCompletionContributor.addDictLiteralKeys((PyDictLiteralExpression)resolvedElement, dictCompletion);
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(parameters.getOriginalFile(), (PsiElement)operand, dictCompletion);
                    }
                    if (resolvedElement instanceof PyCallExpression) {
                        PyDictKeyNamesCompletionContributor.addDictConstructorKeys((PyCallExpression)resolvedElement, dictCompletion);
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(parameters.getOriginalFile(), (PsiElement)operand, dictCompletion);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean addCompletionIfOperandIsTypedDict(@NotNull PyExpression operand, @NotNull DictKeyCompletionResultSet dictCompletion) {
        TypeEvalContext typeEvalContext;
        PyType type;
        if (operand == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (dictCompletion == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((type = (typeEvalContext = TypeEvalContext.codeCompletion((Project)operand.getProject(), (PsiFile)operand.getContainingFile())).getType((PyTypedElement)operand)) instanceof PyTypedDictType) {
            PyTypedDictType dictType = (PyTypedDictType)type;
            for (String key : dictType.getFields().keySet()) {
                dictCompletion.addKey(key);
            }
            return true;
        }
        return false;
    }

    private static void addDictConstructorKeys(PyCallExpression dictConstructor, DictKeyCompletionResultSet result) {
        TypeEvalContext context;
        PyType type;
        PyExpression callee = dictConstructor.getCallee();
        if (callee == null) {
            return;
        }
        String name = callee.getText();
        if ("dict".equals(name) && (type = (context = TypeEvalContext.codeCompletion((Project)callee.getProject(), (PsiFile)callee.getContainingFile())).getType((PyTypedElement)dictConstructor)) != null && type.isBuiltin()) {
            PyExpression[] argumentList;
            PyArgumentList list = dictConstructor.getArgumentList();
            if (list == null) {
                return;
            }
            for (PyExpression argument : argumentList = list.getArguments()) {
                PyKeywordArgument keywordArgument;
                String keyword;
                if (!(argument instanceof PyKeywordArgument) || (keyword = (keywordArgument = (PyKeywordArgument)argument).getKeyword()) == null) continue;
                result.addKey(keyword);
            }
        }
    }

    private static void addAdditionalKeys(PsiFile file, PsiElement operand, DictKeyCompletionResultSet result) {
        Collection subscriptionExpressions = PsiTreeUtil.findChildrenOfType((PsiElement)file, PySubscriptionExpression.class);
        for (PySubscriptionExpression expr : subscriptionExpressions) {
            PyAssignmentStatement assignmentStatement;
            PsiElement psiElement;
            if (!expr.getOperand().getText().equals(operand.getText()) || !((psiElement = expr.getParent()) instanceof PyAssignmentStatement) || !expr.equals((Object)(assignmentStatement = (PyAssignmentStatement)psiElement).getLeftHandSideExpression()) || !((psiElement = expr.getIndexExpression()) instanceof PyStringLiteralExpression)) continue;
            PyStringLiteralExpression key = (PyStringLiteralExpression)psiElement;
            result.addKey(key);
        }
    }

    private static void addDictLiteralKeys(PyDictLiteralExpression dict, DictKeyCompletionResultSet result) {
        PyKeyValueExpression[] keyValues;
        for (PyKeyValueExpression expression : keyValues = dict.getElements()) {
            PyExpression pyExpression = expression.getKey();
            if (!(pyExpression instanceof PyStringLiteralExpression)) continue;
            PyStringLiteralExpression key = (PyStringLiteralExpression)pyExpression;
            result.addKey(key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "operand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dictCompletion";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor";
        objectArray[2] = "addCompletionIfOperandIsTypedDict";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DictKeyCompletionResultSet {
        @NotNull
        private final CompletionResultSet myResult;
        private final boolean myIsInsideString;

        DictKeyCompletionResultSet(@NotNull CompletionResultSet result, boolean isInsideString) {
            if (result == null) {
                DictKeyCompletionResultSet.$$$reportNull$$$0(0);
            }
            this.myResult = result;
            this.myIsInsideString = isInsideString;
        }

        void addKey(@NotNull PyStringLiteralExpression keyExpression) {
            if (keyExpression == null) {
                DictKeyCompletionResultSet.$$$reportNull$$$0(1);
            }
            if (this.myIsInsideString) {
                this.addElement(keyExpression.getStringValue());
            } else {
                this.addElement(keyExpression.getText());
            }
        }

        void addKey(@NotNull String key) {
            if (key == null) {
                DictKeyCompletionResultSet.$$$reportNull$$$0(2);
            }
            String lookupString2 = this.myIsInsideString ? key : "%s%s%s".formatted(PyDictKeyNamesCompletionContributor.DEFAULT_QUOTE, key, PyDictKeyNamesCompletionContributor.DEFAULT_QUOTE);
            this.addElement(lookupString2);
        }

        private void addElement(@NotNull String lookupString2) {
            if (lookupString2 == null) {
                DictKeyCompletionResultSet.$$$reportNull$$$0(3);
            }
            this.myResult.addElement((LookupElement)LookupElementBuilder.create((String)lookupString2).withTypeText("dict key").withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupString";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$DictKeyCompletionResultSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

