/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.navbar.frontend.ui.NewNavBarPanel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.CoroutinesKt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\r*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"showHint", "", "Lkotlinx/coroutines/CoroutineScope;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "panel", "Lcom/intellij/platform/navbar/frontend/ui/NewNavBarPanel;", "showEditorHint", "editor", "Lcom/intellij/openapi/editor/Editor;", "hint", "Lcom/intellij/ui/LightweightHint;", "showNonEditorHint", "wrapNavbarPanel", "Ljavax/swing/JPanel;", "createHint", "contents", "guessEvenBetterPopupLocation", "Lcom/intellij/ui/awt/RelativePoint;", "intellij.platform.navbar.frontend"})
public final class FloatingModeHelperKt {
    public static final void showHint(@NotNull CoroutineScope $this$showHint, @NotNull DataContext dataContext2, @NotNull Project project, @NotNull NewNavBarPanel panel) {
        Intrinsics.checkNotNullParameter((Object)$this$showHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        JPanel wrappedPanel = FloatingModeHelperKt.wrapNavbarPanel(panel);
        LightweightHint hint = FloatingModeHelperKt.createHint($this$showHint, wrappedPanel);
        panel.setOnSizeChange(() -> FloatingModeHelperKt.showHint$lambda$0(hint, wrappedPanel));
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)$this$showHint, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(hint, null){
            int label;
            final /* synthetic */ LightweightHint $hint;
            {
                this.$hint = $hint;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$hint.hide();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Editor editor = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            FloatingModeHelperKt.showEditorHint(editor, project, hint);
        } else {
            FloatingModeHelperKt.showNonEditorHint(dataContext2, project, hint);
        }
    }

    private static final void showEditorHint(Editor editor, Project project, LightweightHint hint) {
        JComponent jComponent = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent hintContainer = jComponent;
        Point point = AbstractPopup.getCenterOf((Component)hintContainer, (JComponent)hint.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getCenterOf(...)");
        Point center = point;
        center.y -= hintContainer.getVisibleRect().height / 4;
        RelativePoint relativePoint = RelativePoint.fromScreen((Point)center);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"fromScreen(...)");
        RelativePoint showPoint = FloatingModeHelperKt.guessEvenBetterPopupLocation(relativePoint, project);
        Point absoluteShowPoint = showPoint.getPointOn((Component)hintContainer).getPoint();
        HintHint hintInfo = new HintHint(editor, absoluteShowPoint);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, absoluteShowPoint, 1, 0, true, hintInfo);
    }

    private static final void showNonEditorHint(DataContext dataContext2, Project project, LightweightHint hint) {
        Component component2 = (Component)dataContext2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        if (component2 == null) {
            return;
        }
        Component contextComponent = component2;
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        RelativePoint showPoint = FloatingModeHelperKt.guessEvenBetterPopupLocation(relativePoint, project);
        Component component3 = showPoint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getComponent(...)");
        Component component4 = component3;
        if (component4 instanceof JComponent && component4.isShowing()) {
            HintHint hintInfo = new HintHint(showPoint.getComponent(), showPoint.getPoint());
            hint.show((JComponent)component4, showPoint.getPoint().x, showPoint.getPoint().y, contextComponent instanceof JComponent ? (JComponent)contextComponent : null, hintInfo);
        }
    }

    private static final JPanel wrapNavbarPanel(NewNavBarPanel panel) {
        JPanel jPanel;
        JPanel $this$wrapNavbarPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$wrapNavbarPanel_u24lambda_u240.add(panel);
        $this$wrapNavbarPanel_u24lambda_u240.setOpaque(true);
        if (ExperimentalUI.Companion.isNewUI()) {
            $this$wrapNavbarPanel_u24lambda_u240.setBorder((Border)new JBEmptyBorder(JBUI.CurrentTheme.StatusBar.Breadcrumbs.floatingBorderInsets()));
            $this$wrapNavbarPanel_u24lambda_u240.setBackground(JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_BACKGROUND);
        } else {
            $this$wrapNavbarPanel_u24lambda_u240.setBackground(UIUtil.getListBackground());
        }
        return jPanel;
    }

    private static final LightweightHint createHint(CoroutineScope $this$createHint, JPanel contents) {
        return new LightweightHint(contents, $this$createHint){
            final /* synthetic */ CoroutineScope $this_createHint;
            {
                this.$this_createHint = $receiver;
                super((JComponent)$contents);
                this.setForceShowAsPopup(true);
                this.setFocusRequestor($contents);
            }

            protected void onPopupCancel() {
                CoroutineScopeKt.cancel((CoroutineScope)this.$this_createHint, null);
            }
        };
    }

    private static final RelativePoint guessEvenBetterPopupLocation(RelativePoint $this$guessEvenBetterPopupLocation, Project project) {
        if ($this$guessEvenBetterPopupLocation.getComponent() instanceof JComponent && $this$guessEvenBetterPopupLocation.getComponent().isShowing()) {
            return $this$guessEvenBetterPopupLocation;
        }
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project);
        Intrinsics.checkNotNull((Object)ideFrame);
        JComponent ideFrame2 = ideFrame.getComponent();
        JRootPane rootPane = UIUtil.getRootPane((Component)ideFrame2);
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        JRootPane jRootPane = rootPane;
        Intrinsics.checkNotNull((Object)jRootPane);
        RelativePoint relativePoint = jBPopupFactory.guessBestPopupLocation((JComponent)jRootPane);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        return relativePoint;
    }

    private static final void showHint$lambda$0(LightweightHint $hint, JPanel $wrappedPanel) {
        $hint.setSize($wrappedPanel.getPreferredSize());
    }
}

