/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.TextLevelRule;

public abstract class AbstractStyleRepeatedWordRule
extends TextLevelRule {
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\"\u201c\u201e\u00bb\u00ab]");
    private static final Pattern ENDING_QUOTES = Pattern.compile("[\"\u201c\u201d\u00bb\u00ab]");
    private static final Pattern SINGLE_QUOTES = Pattern.compile("['\u201a\u2018\u2019'\u203a\u2039]");
    private static final int MAX_TOKEN_TO_CHECK = 5;
    private static final int MAX_DISTANCE_OF_SENTENCES = 1;
    private static final boolean EXCLUDE_DIRECT_SPEECH = true;
    protected final LinguServices linguServices;
    protected final Language lang;
    protected int maxDistanceOfSentences = 1;
    protected boolean excludeDirectSpeech = true;

    public AbstractStyleRepeatedWordRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
        this.setOfficeDefaultOn();
        this.lang = lang;
        if (userConfig != null) {
            Object[] cf;
            this.linguServices = userConfig.getLinguServices();
            if (this.linguServices != null) {
                this.linguServices.setThesaurusRelevantRule(this);
            }
            if ((cf = userConfig.getConfigValueByID(this.getId())) != null) {
                if (cf != null && cf.length > 0 && cf[0] != null && cf[0] instanceof Integer) {
                    this.maxDistanceOfSentences = (Integer)cf[0];
                }
                if (cf != null && cf.length > 1 && cf[1] != null && cf[1] instanceof Boolean) {
                    this.excludeDirectSpeech = (Boolean)cf[1];
                }
            }
        } else {
            this.linguServices = null;
        }
    }

    @Override
    public String getId() {
        return "STYLE_REPEATED_WORD_RULE";
    }

    @Override
    public String getDescription() {
        return "Repeated words in consecutive sentences";
    }

    protected abstract String messageSameSentence();

    protected abstract String messageSentenceBefore();

    protected abstract String messageSentenceAfter();

    @Override
    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption(1, this.messages.getString("guiStyleRepeatedWordText"), 0, 5), new RuleOption(true, this.messages.getString("guiStyleExcludeDirectSpeechText"), 0, 5)};
        return ruleOptions;
    }

    protected abstract boolean isTokenToCheck(AnalyzedTokenReadings var1);

    protected abstract boolean isTokenPair(AnalyzedTokenReadings[] var1, int var2, boolean var3);

    private static boolean hasBreakToken(AnalyzedTokenReadings[] tokens) {
        for (int i = 0; i < tokens.length && i < 5; ++i) {
            if (!tokens[i].getToken().equals("-") && !tokens[i].getToken().equals("\u2014") && !tokens[i].getToken().equals("\u2013")) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuestionResponse(int nAct, int nTest, List<AnalyzedTokenReadings[]> tokenList) {
        int dist = nAct - nTest;
        if (dist != 1 && dist != -1) {
            return false;
        }
        AnalyzedTokenReadings[] actTokens = tokenList.get(nAct);
        AnalyzedTokenReadings[] testTokens = tokenList.get(nTest);
        if (actTokens.length < 2 || testTokens.length < 2) {
            return false;
        }
        String actToken = ENDING_QUOTES.matcher(actTokens[actTokens.length - 1].getToken()).matches() ? actTokens[actTokens.length - 2].getToken() : actTokens[actTokens.length - 1].getToken();
        String testToken = ENDING_QUOTES.matcher(testTokens[testTokens.length - 1].getToken()).matches() ? testTokens[testTokens.length - 2].getToken() : testTokens[testTokens.length - 1].getToken();
        return actToken.equals("?") && !testToken.equals("?") || testToken.equals("?") && !actToken.equals("?");
    }

    private boolean isTokenInSentence(AnalyzedTokenReadings testToken, AnalyzedTokenReadings[] tokens, boolean isDirectSpeech) {
        return this.isTokenInSentence(testToken, tokens, -1, isDirectSpeech);
    }

    protected boolean isPartOfWord(String testTokenText, String tokenText) {
        return false;
    }

    protected boolean isExceptionPair(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        return false;
    }

    protected URL setURL(AnalyzedTokenReadings token) throws MalformedURLException {
        return null;
    }

    private boolean isTokenInSentence(AnalyzedTokenReadings testToken, AnalyzedTokenReadings[] tokens, int notCheck, boolean isDirectSpeech) {
        if (testToken == null || tokens == null) {
            return false;
        }
        List<AnalyzedToken> readings = testToken.getReadings();
        ArrayList<String> lemmas = new ArrayList<String>();
        for (AnalyzedToken reading : readings) {
            if (reading.getLemma() == null) continue;
            lemmas.add(reading.getLemma());
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (this.excludeDirectSpeech && !isDirectSpeech && OPENING_QUOTES.matcher(tokens[i].getToken()).matches() && i < tokens.length - 1 && !tokens[i + 1].isWhitespaceBefore()) {
                isDirectSpeech = true;
                continue;
            }
            if (this.excludeDirectSpeech && isDirectSpeech && ENDING_QUOTES.matcher(tokens[i].getToken()).matches() && i > 1 && !tokens[i].isWhitespaceBefore()) {
                isDirectSpeech = false;
                continue;
            }
            if (i == notCheck || isDirectSpeech || this.isInQuotes(tokens, i) || !this.isTokenToCheck(tokens[i]) || (lemmas.isEmpty() || !tokens[i].hasAnyLemma(lemmas.toArray(new String[0])) || this.isExceptionPair(testToken, tokens[i])) && !this.isPartOfWord(testToken.getToken(), tokens[i].getToken())) continue;
            if (notCheck >= 0) {
                if (notCheck == i - 2) {
                    return !this.isTokenPair(tokens, i, true);
                }
                if (notCheck == i + 2) {
                    return !this.isTokenPair(tokens, i, false);
                }
                if ((notCheck == i + 1 || notCheck == i - 1) && testToken.getToken().equals(tokens[i].getToken())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isInQuotes(AnalyzedTokenReadings[] tokens, int i) {
        return !(i <= 0 || !OPENING_QUOTES.matcher(tokens[i - 1].getToken()).matches() && !SINGLE_QUOTES.matcher(tokens[i - 1].getToken()).matches() || i >= tokens.length - 1 || !ENDING_QUOTES.matcher(tokens[i + 1].getToken()).matches() && !SINGLE_QUOTES.matcher(tokens[i + 1].getToken()).matches());
    }

    private boolean getStartsWithDirectSpeech(int n, List<AnalyzedSentence> sentences, boolean isDirectSpeech) {
        if (!this.excludeDirectSpeech || n <= 0) {
            return false;
        }
        AnalyzedTokenReadings[] sentence = sentences.get(n - 1).getTokensWithoutWhitespace();
        for (int i = 0; i < sentence.length; ++i) {
            AnalyzedTokenReadings token = sentence[i];
            if (!isDirectSpeech && OPENING_QUOTES.matcher(token.getToken()).matches() && i < sentence.length - 1 && !sentence[i + 1].isWhitespaceBefore()) {
                isDirectSpeech = true;
                continue;
            }
            if (!isDirectSpeech || !ENDING_QUOTES.matcher(token.getToken()).matches() || i <= 1 || sentence[i].isWhitespaceBefore()) continue;
            isDirectSpeech = false;
        }
        return isDirectSpeech;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ArrayList<AnalyzedTokenReadings[]> tokenList = new ArrayList<AnalyzedTokenReadings[]>();
        ArrayList<Boolean> isDSList = new ArrayList<Boolean>();
        int pos = 0;
        boolean startsWithDirectSpeech = false;
        for (int n = 0; n < this.maxDistanceOfSentences && n < sentences.size(); ++n) {
            tokenList.add(sentences.get(n).getTokensWithoutWhitespace());
            startsWithDirectSpeech = this.getStartsWithDirectSpeech(n, sentences, startsWithDirectSpeech);
            isDSList.add(startsWithDirectSpeech);
        }
        boolean isDirectSpeech = false;
        for (int n = 0; n < sentences.size(); ++n) {
            if (n + this.maxDistanceOfSentences < sentences.size()) {
                tokenList.add(sentences.get(n + this.maxDistanceOfSentences).getTokensWithoutWhitespace());
                startsWithDirectSpeech = this.getStartsWithDirectSpeech(n + this.maxDistanceOfSentences, sentences, startsWithDirectSpeech);
                isDSList.add(startsWithDirectSpeech);
            }
            if (tokenList.size() > 2 * this.maxDistanceOfSentences + 1) {
                tokenList.remove(0);
                isDSList.remove(0);
            }
            int nTok = this.maxDistanceOfSentences;
            if (n < this.maxDistanceOfSentences) {
                nTok = n;
            } else if (n >= sentences.size() - this.maxDistanceOfSentences) {
                nTok = tokenList.size() - (sentences.size() - n);
            }
            if (!AbstractStyleRepeatedWordRule.hasBreakToken((AnalyzedTokenReadings[])tokenList.get(nTok))) {
                for (int i = 0; i < ((AnalyzedTokenReadings[])tokenList.get(nTok)).length; ++i) {
                    int j;
                    AnalyzedTokenReadings token = ((AnalyzedTokenReadings[])tokenList.get(nTok))[i];
                    if (this.excludeDirectSpeech && !isDirectSpeech && OPENING_QUOTES.matcher(token.getToken()).matches() && i < ((AnalyzedTokenReadings[])tokenList.get(nTok)).length - 1 && !((AnalyzedTokenReadings[])tokenList.get(nTok))[i + 1].isWhitespaceBefore()) {
                        isDirectSpeech = true;
                        continue;
                    }
                    if (this.excludeDirectSpeech && isDirectSpeech && ENDING_QUOTES.matcher(token.getToken()).matches() && i > 1 && !((AnalyzedTokenReadings[])tokenList.get(nTok))[i].isWhitespaceBefore()) {
                        isDirectSpeech = false;
                        continue;
                    }
                    if (isDirectSpeech || this.isInQuotes((AnalyzedTokenReadings[])tokenList.get(nTok), i) || !this.isTokenToCheck(token)) continue;
                    int isRepeated = 0;
                    if (this.isTokenInSentence(token, (AnalyzedTokenReadings[])tokenList.get(nTok), i, (Boolean)isDSList.get(nTok))) {
                        isRepeated = 1;
                    }
                    for (j = nTok - 1; isRepeated == 0 && j >= 0 && j >= nTok - this.maxDistanceOfSentences; --j) {
                        if (AbstractStyleRepeatedWordRule.isQuestionResponse(nTok, j, tokenList) || !this.isTokenInSentence(token, (AnalyzedTokenReadings[])tokenList.get(j), (Boolean)isDSList.get(j))) continue;
                        isRepeated = 2;
                    }
                    for (j = nTok + 1; isRepeated == 0 && j < tokenList.size() && j <= nTok + this.maxDistanceOfSentences; ++j) {
                        if (AbstractStyleRepeatedWordRule.isQuestionResponse(nTok, j, tokenList) || !this.isTokenInSentence(token, (AnalyzedTokenReadings[])tokenList.get(j), (Boolean)isDSList.get(j))) continue;
                        isRepeated = 3;
                    }
                    if (isRepeated == 0) continue;
                    String msg = isRepeated == 1 ? this.messageSameSentence() : (isRepeated == 2 ? this.messageSentenceBefore() : this.messageSentenceAfter());
                    int startPos = pos + token.getStartPos();
                    int endPos = pos + token.getEndPos();
                    RuleMatch ruleMatch = new RuleMatch(this, null, startPos, endPos, msg);
                    URL url = this.setURL(token);
                    if (url != null) {
                        ruleMatch.setUrl(url);
                    }
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentences.get(n).getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return this.excludeDirectSpeech ? -1 : this.maxDistanceOfSentences;
    }
}

