//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_RENDER_VAR_SCHEMA_H
#define PXR_IMAGING_HD_RENDER_VAR_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_RENDER_VAR_SCHEMA_TOKENS \
    (renderVar) \
    (path) \
    (dataType) \
    (sourceName) \
    (sourceType) \
    (namespacedSettings) \

TF_DECLARE_PUBLIC_TOKENS(HdRenderVarSchemaTokens, HD_API,
    HD_RENDER_VAR_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class HdRenderVarSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdRenderVarSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "renderVar" from the parent container and constructs a
    /// HdRenderVarSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdRenderVarSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdPathDataSourceHandle GetPath() const;

    HD_API
    HdTokenDataSourceHandle GetDataType() const;

    HD_API
    HdTokenDataSourceHandle GetSourceName() const;

    HD_API
    HdTokenDataSourceHandle GetSourceType() const;

    HD_API
    HdContainerDataSourceHandle GetNamespacedSettings() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate namespacedSettings.
    HD_API
    static const HdDataSourceLocator &GetNamespacedSettingsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdPathDataSourceHandle &path,
        const HdTokenDataSourceHandle &dataType,
        const HdTokenDataSourceHandle &sourceName,
        const HdTokenDataSourceHandle &sourceType,
        const HdContainerDataSourceHandle &namespacedSettings
    );

    /// \class HdRenderVarSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetPath(
            const HdPathDataSourceHandle &path);
        HD_API
        Builder &SetDataType(
            const HdTokenDataSourceHandle &dataType);
        HD_API
        Builder &SetSourceName(
            const HdTokenDataSourceHandle &sourceName);
        HD_API
        Builder &SetSourceType(
            const HdTokenDataSourceHandle &sourceType);
        HD_API
        Builder &SetNamespacedSettings(
            const HdContainerDataSourceHandle &namespacedSettings);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdPathDataSourceHandle _path;
        HdTokenDataSourceHandle _dataType;
        HdTokenDataSourceHandle _sourceName;
        HdTokenDataSourceHandle _sourceType;
        HdContainerDataSourceHandle _namespacedSettings;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif