# Azure Devops

- Here is the [Azure DevOps Pipelines Task for Trivy][action]

![trivy-azure](https://github.com/aquasecurity/trivy-azure-pipelines-task/blob/main/screenshot.png?raw=true)

### [Use ImageCleaner to clean up stale images on your Azure Kubernetes Service cluster][azure2]

It's common to use pipelines to build and deploy images on Azure Kubernetes Service (AKS) clusters. While great for image creation, this process often doesn't account for the stale images left behind and can lead to image bloat on cluster nodes. These images can present security issues as they may contain vulnerabilities. By cleaning these unreferenced images, you can remove an area of risk in your clusters. When done manually, this process can be time intensive, which ImageCleaner can mitigate via automatic image identification and removal.

 Vulnerability is determined based on a trivy scan, after which images with a LOW, MEDIUM, HIGH, or CRITICAL classification are flagged. An updated ImageList will be automatically generated by ImageCleaner based on a set time interval, and can also be supplied manually.
### [Microsoft Defender for container registries and Trivy][azure]

This blog explains how to scan your Azure Container Registry-based container images with the integrated vulnerability scanner when they're built as part of your GitHub workflows.

To set up the scanner, you'll need to enable Microsoft Defender for Containers and the CI/CD integration. When your CI/CD workflows push images to your registries, you can view registry scan results and a summary of CI/CD scan results.

The findings of the CI/CD scans are an enrichment to the existing registry scan findings by Qualys. Defender for Cloud's CI/CD scanning is powered by Aqua Trivy

[action]: https://github.com/aquasecurity/trivy-azure-pipelines-task
[azure]: https://docs.microsoft.com/en-us/azure/defender-for-cloud/defender-for-containers-cicd
[azure2]: https://docs.microsoft.com/en-us/azure/aks/image-cleaner?tabs=azure-cli
