/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ArrayElementInfoNode;
import com.oracle.truffle.js.nodes.interop.ArrayElementInfoNodeGen;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObjectGen;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSArrayObject.class)
final class JSArrayObjectGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private JSArrayObjectGen() {
    }

    static {
        LibraryExport.register(JSArrayObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSArrayObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSArrayObject.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSArrayObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSArrayObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSArrayObject.class)
        @DenyReplace
        private static final class Uncached
        extends JSNonProxyObjectGen.InteropLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                if (JSGuards.isJSFastArray(arg0Value)) {
                    return JSArrayObject.GetMembers.fastArray(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)this));
                }
                if (!JSGuards.isJSFastArray(arg0Value)) {
                    return JSArrayObject.GetMembers.slowArray(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)this));
                }
                throw Uncached.newUnsupportedSpecializationException2LZ((Node)this, arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayObject)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayObject)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, this, JSObject.getUncachedRead(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementReadable(arg1Value, this);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                arg0Value.writeArrayElement(arg1Value, arg2Value, ArrayElementInfoNodeGen.getUncached(), ImportValueNode.getUncached(), JSObject.getUncachedWrite());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementModifiable(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementInsertable(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                return arg0Value.isArrayElementRemovable(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                arg0Value.removeArrayElement(arg1Value, ArrayElementInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2LZ(Node thisNode_, Object arg0Value, boolean arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
            }
        }

        @GeneratedBy(value=JSArrayObject.class)
        private static final class Cached
        extends JSNonProxyObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaString;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private JSInteropGetIteratorNode getIteratorNode;
            @Node.Child
            private ArrayElementInfoNode elements;
            @Node.Child
            private InteropLibrary getMembers_fastArray_self_;
            @Node.Child
            private InteropLibrary getMembers_slowArray_self_;
            @Node.Child
            private ReadArrayElementNode_ReadArrayElementData readArrayElementNode__readArrayElement_cache;
            @Node.Child
            private WriteArrayElementNode_WriteArrayElementData writeArrayElementNode__writeArrayElement_cache;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    InteropLibrary self__1;
                    InteropLibrary self__;
                    if ((state_0 & 1) != 0 && (self__ = this.getMembers_fastArray_self_) != null && self__.accepts((Object)this) && JSGuards.isJSFastArray(arg0Value)) {
                        return JSArrayObject.GetMembers.fastArray(arg0Value, arg1Value, self__);
                    }
                    if ((state_0 & 2) != 0 && (self__1 = this.getMembers_slowArray_self_) != null && self__1.accepts((Object)this) && !JSGuards.isJSFastArray(arg0Value)) {
                        return JSArrayObject.GetMembers.slowArray(arg0Value, arg1Value, self__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersAndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersAndSpecialize(JSArrayObject arg0Value, boolean arg1Value) {
                int state_0 = this.state_0_;
                if (JSGuards.isJSFastArray(arg0Value)) {
                    InteropLibrary self__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)this)));
                    Objects.requireNonNull(self__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getMembers_fastArray_self_ = self__;
                    this.state_0_ = state_0 |= 1;
                    return JSArrayObject.GetMembers.fastArray(arg0Value, arg1Value, self__);
                }
                if (!JSGuards.isJSFastArray(arg0Value)) {
                    InteropLibrary self__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)this)));
                    Objects.requireNonNull(self__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getMembers_slowArray_self_ = self__1;
                    this.state_0_ = state_0 |= 2;
                    return JSArrayObject.GetMembers.slowArray(arg0Value, arg1Value, self__1);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayObject)receiver).getArraySize();
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                ReadArrayElementNode_ReadArrayElementData s0_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (s0_ = this.readArrayElementNode__readArrayElement_cache) != null) {
                    Cached self__ = this;
                    return arg0Value.readArrayElement(arg1Value, self__, s0_.readNode_, s0_.exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                Cached self__ = null;
                ReadArrayElementNode_ReadArrayElementData s0_ = (ReadArrayElementNode_ReadArrayElementData)this.insert(new ReadArrayElementNode_ReadArrayElementData());
                self__ = this;
                ReadElementNode readNode__ = (ReadElementNode)s0_.insert(ReadElementNode.create(JSObject.language(self__).getJSContext()));
                Objects.requireNonNull(readNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.readNode_ = readNode__;
                ExportValueNode exportNode__ = (ExportValueNode)s0_.insert(ExportValueNode.create());
                Objects.requireNonNull(exportNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.exportNode_ = exportNode__;
                VarHandle.storeStoreFence();
                this.readArrayElementNode__readArrayElement_cache = s0_;
                this.state_0_ = state_0 |= 4;
                return arg0Value.readArrayElement(arg1Value, self__, readNode__, exportNode__);
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                Cached thisLibrary__ = this;
                return arg0Value.isArrayElementReadable(arg1Value, thisLibrary__);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                ArrayElementInfoNode elements_;
                WriteArrayElementNode_WriteArrayElementData s0_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (s0_ = this.writeArrayElementNode__writeArrayElement_cache) != null && (elements_ = this.elements) != null) {
                    arg0Value.writeArrayElement(arg1Value, arg2Value, elements_, s0_.castValueNode_, s0_.writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeArrayElementNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                ArrayElementInfoNode elements_;
                int state_0 = this.state_0_;
                WriteArrayElementNode_WriteArrayElementData s0_ = (WriteArrayElementNode_WriteArrayElementData)this.insert(new WriteArrayElementNode_WriteArrayElementData());
                ArrayElementInfoNode elements__shared = this.elements;
                if (elements__shared != null) {
                    elements_ = elements__shared;
                } else {
                    elements_ = (ArrayElementInfoNode)s0_.insert(ArrayElementInfoNodeGen.create());
                    if (elements_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.elements == null) {
                    this.elements = elements_;
                }
                ImportValueNode castValueNode__ = (ImportValueNode)s0_.insert(ImportValueNode.create());
                Objects.requireNonNull(castValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.castValueNode_ = castValueNode__;
                WriteElementNode writeNode__ = (WriteElementNode)s0_.insert(WriteElementNode.createCachedInterop());
                Objects.requireNonNull(writeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.writeNode_ = writeNode__;
                VarHandle.storeStoreFence();
                this.writeArrayElementNode__writeArrayElement_cache = s0_;
                this.state_0_ = state_0 |= 8;
                arg0Value.writeArrayElement(arg1Value, arg2Value, elements_, castValueNode__, writeNode__);
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                ArrayElementInfoNode elements_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (elements_ = this.elements) != null) {
                    return arg0Value.isArrayElementModifiable(arg1Value, elements_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementModifiableNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) {
                ArrayElementInfoNode elements_;
                int state_0 = this.state_0_;
                ArrayElementInfoNode elements__shared = this.elements;
                if (elements__shared != null) {
                    elements_ = elements__shared;
                } else {
                    elements_ = (ArrayElementInfoNode)this.insert(ArrayElementInfoNodeGen.create());
                    if (elements_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.elements == null) {
                    VarHandle.storeStoreFence();
                    this.elements = elements_;
                }
                this.state_0_ = state_0 |= 0x10;
                return arg0Value.isArrayElementModifiable(arg1Value, elements_);
            }

            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                ArrayElementInfoNode elements_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (elements_ = this.elements) != null) {
                    return arg0Value.isArrayElementInsertable(arg1Value, elements_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) {
                ArrayElementInfoNode elements_;
                int state_0 = this.state_0_;
                ArrayElementInfoNode elements__shared = this.elements;
                if (elements__shared != null) {
                    elements_ = elements__shared;
                } else {
                    elements_ = (ArrayElementInfoNode)this.insert(ArrayElementInfoNodeGen.create());
                    if (elements_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.elements == null) {
                    VarHandle.storeStoreFence();
                    this.elements = elements_;
                }
                this.state_0_ = state_0 |= 0x20;
                return arg0Value.isArrayElementInsertable(arg1Value, elements_);
            }

            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                ArrayElementInfoNode elements_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (elements_ = this.elements) != null) {
                    return arg0Value.isArrayElementRemovable(arg1Value, elements_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementRemovableNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) {
                ArrayElementInfoNode elements_;
                int state_0 = this.state_0_;
                ArrayElementInfoNode elements__shared = this.elements;
                if (elements__shared != null) {
                    elements_ = elements__shared;
                } else {
                    elements_ = (ArrayElementInfoNode)this.insert(ArrayElementInfoNodeGen.create());
                    if (elements_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.elements == null) {
                    VarHandle.storeStoreFence();
                    this.elements = elements_;
                }
                this.state_0_ = state_0 |= 0x40;
                return arg0Value.isArrayElementRemovable(arg1Value, elements_);
            }

            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                ArrayElementInfoNode elements_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSArrayObject arg0Value = (JSArrayObject)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (elements_ = this.elements) != null) {
                    arg0Value.removeArrayElement(arg1Value, elements_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void removeArrayElementNode_AndSpecialize(JSArrayObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                ArrayElementInfoNode elements_;
                int state_0 = this.state_0_;
                ArrayElementInfoNode elements__shared = this.elements;
                if (elements__shared != null) {
                    elements_ = elements__shared;
                } else {
                    elements_ = (ArrayElementInfoNode)this.insert(ArrayElementInfoNodeGen.create());
                    if (elements_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.elements == null) {
                    VarHandle.storeStoreFence();
                    this.elements = elements_;
                }
                this.state_0_ = state_0 |= 0x80;
                arg0Value.removeArrayElement(arg1Value, elements_);
            }

            @GeneratedBy(value=JSArrayObject.class)
            @DenyReplace
            private static final class ReadArrayElementNode_ReadArrayElementData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ReadElementNode readNode_;
                @Node.Child
                ExportValueNode exportNode_;

                ReadArrayElementNode_ReadArrayElementData() {
                }
            }

            @GeneratedBy(value=JSArrayObject.class)
            @DenyReplace
            private static final class WriteArrayElementNode_WriteArrayElementData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ImportValueNode castValueNode_;
                @Node.Child
                WriteElementNode writeNode_;

                WriteArrayElementNode_WriteArrayElementData() {
                }
            }
        }
    }
}

