/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt;

import com.informix.jdbc.IfxUDTInput;
import java.nio.charset.Charset;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Arrays;

public class Binary18
implements SQLData {
    private byte[] bytes;
    private Charset defaultCharset = Charset.defaultCharset();

    public Binary18() {
    }

    public Binary18(byte[] bytes) {
        this.bytes = bytes;
    }

    public Binary18(byte[] bytes, Charset cs) {
        this.bytes = bytes;
        this.defaultCharset = cs;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "binary18";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        IfxUDTInput input = (IfxUDTInput)stream;
        this.bytes = input.readBytes(input.length());
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeBytes(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toString(this.defaultCharset);
    }

    public String toString(Charset cs) {
        for (int i = 17; i > 0; --i) {
            if (this.bytes[i] == 0) continue;
            return new String(Arrays.copyOf(this.bytes, i + 1));
        }
        return new String(this.bytes, cs);
    }
}

