/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.jniutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import xsbt.boot.internal.shaded.coursier.jniutils.DllName;

public final class LoadWindowsLibrary {
    static final Object lock = new Object();
    static boolean initialized = false;

    static File fromClassPath(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                for (URL uRL : uRLClassLoader.getURLs()) {
                    File file;
                    if (!uRL.getProtocol().equals("file")) continue;
                    try {
                        file = new File(uRL.toURI()).getAbsoluteFile();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new RuntimeException(uRISyntaxException);
                    }
                    if (!file.getName().equals(LoadWindowsLibrary.dllName() + ".dll") || !file.isFile()) continue;
                    return file;
                }
            } else if (classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$AppClassLoader")) {
                String string = System.getProperty("java.class.path");
                for (String string2 : string.split(File.pathSeparator)) {
                    File file = new File(string2).getAbsoluteFile();
                    if (!file.getName().equals(LoadWindowsLibrary.dllName() + ".dll") || !file.isFile()) continue;
                    return file;
                }
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    static File fromResources(ClassLoader object) throws IOException, URISyntaxException {
        Object object2;
        Throwable throwable;
        Object object3;
        Throwable throwable2;
        block30: {
            block29: {
                if ((object = ((ClassLoader)object).getResource(LoadWindowsLibrary.dllResourcePath())) == null) {
                    return null;
                }
                if (((URL)object).getProtocol().equals("file")) {
                    return new File(((URL)object).toURI());
                }
                object = ((URL)object).openStream();
                throwable2 = null;
                object3 = Channels.newChannel((InputStream)object);
                throwable = null;
                Serializable serializable = File.createTempFile(LoadWindowsLibrary.dllName(), ".dll");
                serializable.deleteOnExit();
                object2 = new FileOutputStream((File)serializable);
                Throwable throwable3 = null;
                try {
                    ((FileOutputStream)object2).getChannel().transferFrom((ReadableByteChannel)object3, 0L, Long.MAX_VALUE);
                }
                catch (Throwable throwable4) {
                    try {
                        serializable = throwable4;
                        throwable3 = throwable4;
                        throw serializable;
                    }
                    catch (Throwable throwable5) {
                        if (throwable3 != null) {
                            try {
                                ((FileOutputStream)object2).close();
                            }
                            catch (Throwable throwable6) {
                                throwable3.addSuppressed(throwable6);
                            }
                        } else {
                            ((FileOutputStream)object2).close();
                        }
                        throw throwable5;
                    }
                }
                ((FileOutputStream)object2).close();
                object2 = serializable;
                if (object3 == null) break block29;
                object3.close();
            }
            if (object == null) break block30;
            ((InputStream)object).close();
        }
        return object2;
        {
            catch (Throwable throwable7) {
                try {
                    try {
                        try {
                            Throwable throwable8 = throwable7;
                            throwable = throwable7;
                            throw throwable8;
                        }
                        catch (Throwable throwable9) {
                            if (object3 != null) {
                                if (throwable != null) {
                                    try {
                                        object3.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable.addSuppressed(throwable10);
                                    }
                                } else {
                                    object3.close();
                                }
                            }
                            throw throwable9;
                        }
                    }
                    catch (Throwable throwable11) {
                        object3 = throwable11;
                        throwable2 = throwable11;
                        throw object3;
                    }
                }
                catch (Throwable throwable12) {
                    if (object != null) {
                        if (throwable2 != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable13) {
                                throwable2.addSuppressed(throwable13);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                    throw throwable12;
                }
            }
        }
    }

    public static void ensureInitialized() {
        if (!initialized) {
            Object object = lock;
            synchronized (object) {
                if (!initialized) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    File file = LoadWindowsLibrary.fromClassPath(classLoader);
                    if (file == null) {
                        try {
                            file = LoadWindowsLibrary.fromResources(classLoader);
                        }
                        catch (IOException | URISyntaxException exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                    if (file == null) {
                        System.loadLibrary(LoadWindowsLibrary.dllName());
                    } else {
                        System.load(file.getAbsolutePath());
                    }
                }
                return;
            }
        }
    }

    static final String dllName() {
        return DllName.name;
    }

    static final String dllResourcePath() {
        return "META-INF/native/windows64/" + LoadWindowsLibrary.dllName() + ".dll";
    }
}

