/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeAlternative;
import com.plantuml.ubrex.ChallengeCharClass;
import com.plantuml.ubrex.ChallengeCharSet;
import com.plantuml.ubrex.ChallengeEndOfText;
import com.plantuml.ubrex.ChallengeLazzyOneOrMore;
import com.plantuml.ubrex.ChallengeLookAhead;
import com.plantuml.ubrex.ChallengeLookBehind;
import com.plantuml.ubrex.ChallengeOneOrMore;
import com.plantuml.ubrex.ChallengeOneOrMoreUpToOldVersion;
import com.plantuml.ubrex.ChallengeOptional;
import com.plantuml.ubrex.ChallengeRepetition;
import com.plantuml.ubrex.ChallengeSingleChar;
import com.plantuml.ubrex.ChallengeUpTo;
import com.plantuml.ubrex.ChallengeZeroOrMore;
import com.plantuml.ubrex.CharClass;
import com.plantuml.ubrex.CompositeList;
import com.plantuml.ubrex.CompositeNamed;
import com.plantuml.ubrex.LookAround;
import com.plantuml.ubrex.Repetition;
import com.plantuml.ubrex.TextNavigator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AtomicParser {
    private static int getClosingBracket(TextNavigator input, char open, char close) {
        int level = 0;
        for (int i = 1; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch == open) {
                ++level;
                continue;
            }
            if (ch != close) continue;
            if (level == 0) {
                return i;
            }
            if (--level >= 0) continue;
            throw new IllegalArgumentException();
        }
        return -1;
    }

    private Challenge parseSingle(TextNavigator input) {
        List<Challenge> result = this.parse(input);
        if (result.size() != 1) {
            throw new UnsupportedOperationException();
        }
        return result.get(0);
    }

    public List<Challenge> parse(TextNavigator input) {
        switch (input.charAt(0)) {
            case '\u2507': {
                throw new IllegalArgumentException();
            }
            case '\u3012': {
                return Collections.singletonList(this.manageLookAround(input));
            }
            case '\u3010': {
                return Collections.singletonList(this.manageAlternative(input));
            }
            case '\u3007': {
                return Collections.singletonList(this.manageQuantifier(input));
            }
            case '\u3004': {
                return this.manageUpTo(input);
            }
            case '\u3018': {
                return Collections.singletonList(this.manageGroup(input));
            }
            case '\u300c': {
                return Collections.singletonList(this.manageCharacterSet(input));
            }
            case '\u3034': {
                return Collections.singletonList(this.manageClass(input));
            }
            case '\u3036': {
                return Collections.singletonList(this.manageNamed(input));
            }
            case '\u3003': {
                return Collections.singletonList(this.manageDoubleQuote(input));
            }
        }
        return Collections.singletonList(this.manageRegularCharacter(input));
    }

    private Challenge manageLookAround(TextNavigator input) {
        Challenge result;
        input.jump(1);
        LookAround look = LookAround.from(input);
        if (look == null) {
            throw new UnsupportedOperationException("Syntax error");
        }
        input.jump(look.getDefinitionSize());
        if (look == LookAround.END_OF_TEXT) {
            result = new ChallengeEndOfText();
        } else {
            Challenge p1 = this.parseSingle(input);
            if (look.isLookBehind()) {
                result = new ChallengeLookBehind(p1, look);
            } else if (look.isLookAhead()) {
                result = new ChallengeLookAhead(p1, look);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private Challenge manageClass(TextNavigator input) {
        input.jump(1);
        CharClass result = CharClass.fromDefinition(input);
        input.jump(result.getDefinitionLength());
        return new ChallengeCharClass(result);
    }

    private Challenge manageQuantifier(TextNavigator input) {
        char operator = input.charAt(1);
        input.jump(2);
        if (operator == '{') {
            return this.manageQuantifierBracket(input);
        }
        if (operator == 'l') {
            return this.manageQuantifierLazzy(input);
        }
        Challenge origin = this.parseSingle(input);
        switch (operator) {
            case '+': {
                return new ChallengeOneOrMore(origin);
            }
            case '*': {
                return new ChallengeZeroOrMore(origin);
            }
            case '?': {
                return new ChallengeOptional(origin);
            }
        }
        throw new UnsupportedOperationException("wip01");
    }

    private Challenge manageQuantifierLazzy(TextNavigator input) {
        input.jump(1);
        Challenge origin = this.parseSingle(input);
        CompositeList remaining = CompositeList.parseAndBuildFromTextNavigator(input);
        return new ChallengeLazzyOneOrMore(origin, remaining);
    }

    private Challenge manageQuantifierBracket(TextNavigator input) {
        Repetition repetition = Repetition.parse(input);
        Challenge origin = this.parseSingle(input);
        return new ChallengeRepetition(repetition, origin);
    }

    private List<Challenge> manageUpTo(TextNavigator input) {
        char operator = input.charAt(1);
        if (operator == '>') {
            input.jump(2);
            Challenge p2 = this.parseSingle(input);
            return Arrays.asList(new ChallengeUpTo(p2), p2);
        }
        if (operator != '+') {
            throw new UnsupportedOperationException("manageQuantifierUpTo1");
        }
        input.jump(2);
        this.skipSpaces(input);
        Challenge p1 = this.parseSingle(input);
        this.skipSpaces(input);
        if (input.charAt(0) != '-') {
            throw new UnsupportedOperationException("manageQuantifierUpTo2");
        }
        if (input.charAt(1) != '>') {
            throw new UnsupportedOperationException("manageQuantifierUpTo2");
        }
        input.jump(2);
        this.skipSpaces(input);
        Challenge p2 = this.parseSingle(input);
        return Arrays.asList(new ChallengeOneOrMoreUpToOldVersion(p1, p2), p2);
    }

    private void skipSpaces(TextNavigator input) {
        while (input.charAt(0) == ' ') {
            input.jump(1);
        }
    }

    private Challenge manageGroup(TextNavigator input) {
        int end = AtomicParser.getClosingBracket(input, '\u3018', '\u3019');
        if (end == -1) {
            throw new UnsupportedOperationException("wip99");
        }
        CompositeList result = CompositeList.parseAndBuild(input.subSequence(1, end));
        input.jump(end + 1);
        return result;
    }

    private Challenge manageAlternative(TextNavigator input) {
        ChallengeAlternative result = new ChallengeAlternative();
        int start = 1;
        int level = 0;
        for (int i = 1; i < input.length(); ++i) {
            CompositeList part;
            char ch = input.charAt(i);
            if (ch == '\u3010') {
                ++level;
                continue;
            }
            if (level == 0 && ch == '\u2507') {
                part = CompositeList.parseAndBuild(input.subSequence(start, i));
                result.addAlternative(part);
                start = i + 1;
                continue;
            }
            if (ch != '\u3011') continue;
            if (level == 0) {
                part = CompositeList.parseAndBuild(input.subSequence(start, i));
                result.addAlternative(part);
                input.jump(i + 1);
                return result;
            }
            if (--level >= 0) continue;
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException("wip32");
    }

    private Challenge manageNamed(TextNavigator input) {
        StringBuilder name = new StringBuilder();
        if (input.charAt(1) != '$') {
            throw new UnsupportedOperationException("varname must have a $");
        }
        input.jump(2);
        while (true) {
            char ch = input.charAt(0);
            input.jump(1);
            if (ch == '=') {
                if (name.length() == 0) {
                    throw new UnsupportedOperationException("no name!");
                }
                CompositeNamed result = new CompositeNamed(name.toString(), this.parse(input));
                return result;
            }
            if (!Character.isJavaIdentifierPart(ch)) break;
            name.append(ch);
        }
        throw new UnsupportedOperationException("Unsupported name!");
    }

    private Challenge manageCharacterSet(TextNavigator input) {
        int end = input.indexOf('\u300d');
        if (end == -1) {
            throw new UnsupportedOperationException("wip80");
        }
        ChallengeCharSet result = ChallengeCharSet.build(input.subSequence(1, end));
        input.jump(end + 1);
        return result;
    }

    private Challenge manageRegularCharacter(TextNavigator input) {
        char ch = input.charAt(0);
        if (ch == ' ') {
            throw new IllegalStateException("no space allowed");
        }
        if (ch == '\u2219') {
            ch = ' ';
        }
        input.jump(1);
        return new ChallengeSingleChar(ch);
    }

    private Challenge manageDoubleQuote(TextNavigator input) {
        input.jump(1);
        return new ChallengeSingleChar('\"');
    }
}

