/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.converter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.legacy.expression.core.Expression;
import org.opensearch.sql.legacy.expression.core.ExpressionFactory;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperation;
import org.opensearch.sql.legacy.expression.model.ExprValueFactory;
import org.opensearch.sql.legacy.query.planner.converter.SQLAggregationParser;

public class SQLExprToExpressionConverter {
    private static final Map<SQLBinaryOperator, ScalarOperation> binaryOperatorOperationMap = new ImmutableMap.Builder().put((Object)SQLBinaryOperator.Add, (Object)ScalarOperation.ADD).put((Object)SQLBinaryOperator.Subtract, (Object)ScalarOperation.SUBTRACT).put((Object)SQLBinaryOperator.Multiply, (Object)ScalarOperation.MULTIPLY).put((Object)SQLBinaryOperator.Divide, (Object)ScalarOperation.DIVIDE).put((Object)SQLBinaryOperator.Modulus, (Object)ScalarOperation.MODULES).build();
    private static final Map<String, ScalarOperation> methodOperationMap = new ImmutableMap.Builder().put((Object)ScalarOperation.ABS.getName(), (Object)ScalarOperation.ABS).put((Object)ScalarOperation.ACOS.getName(), (Object)ScalarOperation.ACOS).put((Object)ScalarOperation.ASIN.getName(), (Object)ScalarOperation.ASIN).put((Object)ScalarOperation.ATAN.getName(), (Object)ScalarOperation.ATAN).put((Object)ScalarOperation.ATAN2.getName(), (Object)ScalarOperation.ATAN2).put((Object)ScalarOperation.TAN.getName(), (Object)ScalarOperation.TAN).put((Object)ScalarOperation.CBRT.getName(), (Object)ScalarOperation.CBRT).put((Object)ScalarOperation.CEIL.getName(), (Object)ScalarOperation.CEIL).put((Object)ScalarOperation.COS.getName(), (Object)ScalarOperation.COS).put((Object)ScalarOperation.COSH.getName(), (Object)ScalarOperation.COSH).put((Object)ScalarOperation.EXP.getName(), (Object)ScalarOperation.EXP).put((Object)ScalarOperation.FLOOR.getName(), (Object)ScalarOperation.FLOOR).put((Object)ScalarOperation.LN.getName(), (Object)ScalarOperation.LN).put((Object)ScalarOperation.LOG.getName(), (Object)ScalarOperation.LOG).put((Object)ScalarOperation.LOG2.getName(), (Object)ScalarOperation.LOG2).put((Object)ScalarOperation.LOG10.getName(), (Object)ScalarOperation.LOG10).build();
    private final SQLAggregationParser.Context context;

    public Expression convert(SQLExpr expr) {
        Optional<Expression> resolvedExpression = this.context.resolve(expr);
        if (resolvedExpression.isPresent()) {
            return resolvedExpression.get();
        }
        if (expr instanceof SQLBinaryOpExpr) {
            return this.binaryOperatorToExpression((SQLBinaryOpExpr)expr, this::convert);
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            return this.methodToExpression((SQLMethodInvokeExpr)expr, this::convert);
        }
        if (expr instanceof SQLValuableExpr) {
            return ExpressionFactory.literal(ExprValueFactory.from(((SQLValuableExpr)expr).getValue()));
        }
        if (expr instanceof SQLCastExpr) {
            return ExpressionFactory.cast(this.convert(((SQLCastExpr)expr).getExpr()));
        }
        throw new RuntimeException("unsupported expr: " + String.valueOf(expr));
    }

    private Expression binaryOperatorToExpression(SQLBinaryOpExpr expr, Function<SQLExpr, Expression> converter) {
        if (binaryOperatorOperationMap.containsKey(expr.getOperator())) {
            return ExpressionFactory.of(binaryOperatorOperationMap.get(expr.getOperator()), Arrays.asList(converter.apply(expr.getLeft()), converter.apply(expr.getRight())));
        }
        throw new UnsupportedOperationException("unsupported operator: " + expr.getOperator().getName());
    }

    private Expression methodToExpression(SQLMethodInvokeExpr expr, Function<SQLExpr, Expression> converter) {
        String methodName = expr.getMethodName().toLowerCase();
        if (methodOperationMap.containsKey(methodName)) {
            return ExpressionFactory.of(methodOperationMap.get(methodName), expr.getParameters().stream().map(converter).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("unsupported operator: " + expr.getMethodName());
    }

    @Generated
    public SQLExprToExpressionConverter(SQLAggregationParser.Context context) {
        this.context = context;
    }
}

